/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.document.PSMLFiles;
import com.pageseeder.base.inspect.FileInspection;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.util.ISO8601;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.pageseeder.psml.template.Processor;
import org.pageseeder.psml.template.TemplateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class PSMLMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSMLMetadata.class);

    private PSMLMetadata() {
    }

    public static boolean generateMetadataFile(File original, String groupTemplate, String groupName, OutputStream metadata) {
        boolean usesMetadata;
        String extension = original.getName().substring(original.getName().lastIndexOf(46) + 1);
        File mediaTemplate = PSMLFiles.findExtensionMediaTemplate(groupTemplate, extension);
        if (mediaTemplate == null) {
            return false;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            Files.copy((File)mediaTemplate, (OutputStream)stream);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to read template file for {} in {}: {}", new Object[]{extension, groupName, ex.getLocalizedMessage(), ex});
            return false;
        }
        String mediaTemplateContent = stream.toString(StandardCharsets.UTF_8);
        HashMap<String, String> params = new HashMap<String, String>();
        boolean bl = usesMetadata = mediaTemplateContent.contains("name=\"meta.") || mediaTemplateContent.contains("{$parammeta.");
        if (usesMetadata) {
            Map<String, String> atts = FileInspection.inspect(original);
            for (Map.Entry<String, String> attribute : atts.entrySet()) {
                String name = attribute.getKey();
                String value = PSMLMetadata.cleanValue(name, attribute.getValue());
                params.put(name, value);
            }
        }
        params.put("ps.filename", original.getName());
        params.put("ps.group", groupName);
        Processor processor = new Processor(StandardCharsets.UTF_8);
        processor.setFailOnError(true);
        long now = System.currentTimeMillis();
        params.put("ps.currentdate", ISO8601.format((long)now, (ISO8601)ISO8601.CALENDAR_DATE));
        params.put("ps.currentdatetime", ISO8601.format((long)now, (ISO8601)ISO8601.DATETIME));
        params.put("ps.currenttime", ISO8601.format((long)now, (ISO8601)ISO8601.TIME));
        try (PrintWriter output = new PrintWriter(new OutputStreamWriter(metadata, StandardCharsets.UTF_8));){
            processor.process(new InputSource(new StringReader(mediaTemplateContent)), output, params);
        }
        catch (IOException | TemplateException ex) {
            LOGGER.error("Failed to create metadata content for {} in {}: {}", new Object[]{original.getName(), groupName, ex.getLocalizedMessage(), ex});
            return false;
        }
        return true;
    }

    private static String cleanValue(String name, String value) {
        if ("meta.cp-keywords".equals(name) || "meta.docinfo-keywords".equals(name) || "meta.iptc-keywords".equals(name)) {
            String clean = value.replaceAll("\\s{0,50}[;,]\\s{0,50}", ",").replaceAll("[^a-zA-Z0-9_\\-,]", "_");
            int i = clean.lastIndexOf(44);
            while (clean.length() > 250 && i != -1) {
                clean = clean.substring(0, i);
                i = clean.lastIndexOf(44);
            }
            return clean.substring(0, Math.min(clean.length(), 250));
        }
        if ("meta.dc-title".equals(name) || "meta.docinfo-title".equals(name) || "meta.exif-image-description".equals(name)) {
            return value.substring(0, Math.min(value.length(), 250));
        }
        return value;
    }
}

