/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base.document;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.diff.OriginTracker;
import com.pageseeder.base.diff.TrackedContent;
import com.pageseeder.base.diff.TrackedSequence;
import com.pageseeder.base.diff.TrackedToken;
import com.pageseeder.base.diff.TrackerXMLOutput;
import com.pageseeder.base.document.FragmentTracker;
import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.base.document.StructureBuilder;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.net.URLCoder;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Rules;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.ReverseXRefs;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.model.XLinkForAttachedXLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.ObjectProperties;
import com.pageseeder.db.util.URIs;
import com.pageseeder.db.util.XLinks;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.diffx.DiffException;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PSMLContentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSMLContentBuilder.class);
    private static final int MAX_VERSIONS = 100;
    private static final String LABELS_ELEMENT = "labels";
    private static final String SCHEMA_VERSION_ATTRIBUTE = "schemaversion";
    private static final String SCHEMA_VERSION_VALUE = "1.4";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String ID_ATTRIBUTE = "id";
    private static final String LEVEL_ATTRIBUTE = "level";
    private static final String VERSION_ELEMENT = "version";
    private final URI uri;
    private final Group group;
    private final @Nullable Group xrefGroup;
    private final Database database;
    private Transaction transaction = null;
    private @Nullable Long draftMemberId = null;
    private @Nullable XLink version = null;
    private boolean originalVersion = false;
    private boolean trackOriginal = false;
    private @Nullable ReverseXRefs loadedReverseXRefs = null;
    private @Nullable Map<String, Collection<Long>> loadedOutgoingXRefs = null;
    private final Map<String, LoadedXLink> fragmentsInTheDB = new HashMap<String, LoadedXLink>();
    private boolean track = false;
    private long compareId = -1L;
    private @Nullable Map<String, List<Long>> fragmentEditIDs = null;
    private @Nullable Map<String, TrackedFragment> fragmentTracking = null;
    private int editsTrackedCounter = 0;

    public PSMLContentBuilder(URI u, Group grp, Database db) throws QueryFailedException {
        this.uri = u;
        this.group = u.getExternal() != false ? GroupRule.getPublicGroup(db) : grp;
        this.xrefGroup = grp;
        this.database = db;
    }

    public void setTransaction(Transaction tr) {
        this.transaction = tr;
    }

    public void setVersion(@Nullable XLink release) {
        this.version = release;
    }

    void setOriginalVersion() {
        this.originalVersion = true;
    }

    void setTrackOriginal() {
        this.trackOriginal = true;
    }

    void setCompareId(long compareid) {
        this.compareId = compareid;
    }

    void setTrack(boolean trackFlag) {
        this.track = trackFlag;
    }

    void setDraftMemberId(Long id) {
        this.draftMemberId = id;
    }

    private @Nullable Collection<Long> getReverseXRefs(String fragment) throws QueryFailedException {
        if (this.xrefGroup == null) {
            return null;
        }
        if (this.loadedReverseXRefs == null) {
            Date limitDate = this.version != null ? this.version.getDate() : (this.originalVersion ? this.uri.getDateCreated() : null);
            this.loadedReverseXRefs = DatabaseQuery.getXLinksByURIGroupReverseXRefsCreationBeforeStatusChangedAfter((Database)this.database, (URI)this.uri, (Group)this.xrefGroup, (Date)limitDate, (Date)limitDate, (int)1, (int)(GlobalSettings.getInt((String)"maxReverseXRefs", (int)1000) + 1));
        }
        return this.loadedReverseXRefs == null ? null : this.loadedReverseXRefs.getReverseXRefs(fragment);
    }

    public URI getURI() {
        return this.uri;
    }

    private @Nullable Collection<Long> getOutgoingXRefs(String fragment) throws QueryFailedException {
        if (this.loadedOutgoingXRefs == null) {
            Date limitDate = this.version != null ? this.version.getDate() : (this.originalVersion ? this.uri.getDateCreated() : null);
            this.loadedOutgoingXRefs = DatabaseQuery.getXLinksByURIGroupOutgoingXRefsFragmentCreationBeforeStatusChangedAfter((Database)this.database, (URI)this.uri, (Group)this.group, (Date)limitDate, (Date)limitDate);
        }
        return this.loadedOutgoingXRefs == null ? null : this.loadedOutgoingXRefs.get(fragment);
    }

    public void document(@Nullable Attributes attributes, XMLWriter output) throws IOException {
        Date date;
        output.openElement("document");
        output.attribute(ID_ATTRIBUTE, String.valueOf(this.uri.getId()));
        output.attribute(SCHEMA_VERSION_ATTRIBUTE, SCHEMA_VERSION_VALUE);
        String type = URIRule.getStyleConfig(this.uri);
        if (type != null) {
            output.attribute(TYPE_ATTRIBUTE, type);
        }
        Date date2 = date = this.uri.getLastModified() != null ? this.uri.getLastModified() : this.uri.getDateCreated();
        if (this.originalVersion) {
            date = this.uri.getDateCreated();
        } else if (this.version != null) {
            date = this.version.getDate();
        }
        if (date != null) {
            output.attribute("date", ISO8601.format((long)date.getTime(), (ISO8601)ISO8601.DATETIME));
        }
        if (!this.originalVersion) {
            try {
                List<XLink> workflows = URIRule.getWorkflowsForURI(this.database, this.uri, null);
                ListIterator<XLink> workflowi = workflows.listIterator(workflows.size());
                while (workflowi.hasPrevious()) {
                    XLink workflow = workflowi.previous();
                    if (this.version != null && workflow.getId() > this.version.getId()) continue;
                    output.attribute("status", workflow.getStatus());
                    break;
                }
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load status", (Throwable)ex);
            }
        }
        if (this.version != null) {
            output.attribute(VERSION_ELEMENT, (String)(XLinks.isVersion((XLink)this.version) ? this.version.getContentTitle() : "event:" + this.version.getId()));
        } else if (this.originalVersion) {
            output.attribute(VERSION_ELEMENT, "original");
        } else {
            output.attribute(VERSION_ELEMENT, "current");
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getLocalName(i);
                if (ID_ATTRIBUTE.equals(name) || SCHEMA_VERSION_ATTRIBUTE.equals(name) || VERSION_ELEMENT.equals(name) || TYPE_ATTRIBUTE.equals(name) || LEVEL_ATTRIBUTE.equals(name) || "status".equals(name) || "date".equals(name)) continue;
                output.attribute(name, attributes.getValue(i));
            }
            output.attribute(LEVEL_ATTRIBUTE, "portable");
        } else {
            output.attribute(LEVEL_ATTRIBUTE, "metadata");
        }
    }

    public boolean fragment(String fragment, FragmentDetailsLoader loader, boolean resolveXRefs, boolean includeDraft, XMLWriter output) throws IOException {
        XLink lastedit;
        if (this.track) {
            TrackedFragment tracked = this.getTrackedSequence(fragment);
            try {
                if (tracked != null) {
                    StringWriter psml = new StringWriter();
                    TrackerXMLOutput<FragmentTracker.Edit> resultsOutput = new TrackerXMLOutput<FragmentTracker.Edit>(psml);
                    resultsOutput.setReference(FragmentTracker::toOriginReference);
                    resultsOutput.setTextFormat(FragmentTracker::toOriginAttributes);
                    resultsOutput.setElement(Operator.INS);
                    resultsOutput.write(tracked.forward);
                    output.writeXML(psml.toString());
                    return true;
                }
            }
            catch (DiffException ex) {
                LOGGER.error("Failed to compute diffX when tracking document changes for fragment {} in document {}", new Object[]{fragment, this.uri.getId(), ex});
                return false;
            }
        }
        if ((lastedit = this.loadLastEditFragmentFromDB(fragment, false)) == null) {
            String labels;
            String content = loader.getFragmentContent(fragment);
            String string = labels = "default".equalsIgnoreCase(fragment) ? null : loader.getLabels(fragment);
            if (content != null) {
                this.resolveLabelsXRefs(fragment, content, true, labels, resolveXRefs && !content.startsWith("<media-fragment"), output);
                return true;
            }
            if (includeDraft) {
                return this.draft(fragment, output);
            }
            return false;
        }
        if ("Documentation-Hidden".equals(lastedit.getContentRole())) {
            return true;
        }
        Iterator contents = lastedit.getContents();
        if (contents.hasNext()) {
            Content c = (Content)contents.next();
            String mediatype = c.getType();
            String labels = String.join((CharSequence)",", Labels.getLabels((XLink)lastedit));
            if ("application/vnd.pageseeder.psml+xml".equals(mediatype)) {
                this.resolveLabelsXRefs(fragment, c.getData(), false, labels, resolveXRefs && !"Documentation-Draft".equals(lastedit.getStatus()), output);
            } else {
                output.openElement("media-fragment");
                output.attribute(ID_ATTRIBUTE, fragment);
                String type = PSMLContentUtils.getFragmentType(lastedit);
                if (type != null) {
                    output.attribute(TYPE_ATTRIBUTE, type);
                }
                if (labels != null && !labels.isEmpty()) {
                    output.attribute(LABELS_ELEMENT, labels);
                }
                if (mediatype != null) {
                    output.attribute("mediatype", mediatype);
                    if (RuleUtils.isXMLMediaType(mediatype)) {
                        output.writeXML(c.getData());
                    } else {
                        output.writeText(c.getData());
                    }
                } else {
                    output.writeText(c.getData());
                }
                output.closeElement();
            }
        }
        return true;
    }

    private boolean draft(String fragment, XMLWriter output) throws IOException {
        XLink lastdraft = this.loadLastEditFragmentFromDB(fragment, true);
        if (lastdraft == null || !"Documentation-Draft".equals(lastdraft.getStatus())) {
            return false;
        }
        Iterator contents = lastdraft.getContents();
        if (contents.hasNext()) {
            Content c = (Content)contents.next();
            String mediatype = c.getType();
            if ("application/vnd.pageseeder.psml+xml".equals(mediatype)) {
                Matcher m = PSMLContentUtils.FRAGMENT_PATTERN.matcher(c.getData());
                if (m.find()) {
                    output.openElement(m.group(1));
                    output.attribute(ID_ATTRIBUTE, fragment);
                    output.closeElement();
                }
            } else {
                output.openElement("media-fragment");
                output.attribute(ID_ATTRIBUTE, fragment);
                String type = PSMLContentUtils.getFragmentType(lastdraft);
                if (type != null) {
                    output.attribute(TYPE_ATTRIBUTE, type);
                }
                if (mediatype != null) {
                    output.attribute("mediatype", mediatype);
                }
                output.closeElement();
            }
            return true;
        }
        return false;
    }

    private void resolveLabelsXRefs(String fragment, @Nullable String xmlContent, boolean orig, @Nullable String labels, boolean xref, XMLWriter output) throws IOException {
        if (xmlContent == null || xmlContent.isEmpty()) {
            return;
        }
        try {
            ArrayList<XRef> xrefs = null;
            if (xref) {
                xrefs = new ArrayList<XRef>();
                Collection<Long> xlids = this.getOutgoingXRefs(fragment);
                if (xlids != null) {
                    for (Long xlid : xlids) {
                        try {
                            xrefs.add(new XRef(DatabaseQuery.getXLinkById((Database)this.database, (Long)xlid)));
                        }
                        catch (IllegalArgumentException ex) {
                            LOGGER.error("Found invalid XRef XLink {}: {}", (Object)xlid, (Object)ex.getMessage());
                        }
                    }
                }
            }
            XRefCreator xrefCreator = new XRefCreator(this.database, this.uri, fragment, this.group, xrefs, orig, labels, output);
            ArrayList<String> errors = new ArrayList<String>();
            try {
                XMLHelpers.parse(new ByteArrayInputStream(xmlContent.getBytes(StandardCharsets.UTF_8)), xrefCreator, errors, null);
            }
            catch (FoundationException ex) {
                LOGGER.error("Failed to parse PSML from DB for fragment {}", (Object)fragment, (Object)ex);
                throw new IOException("Failed to parse PSML from DB", ex);
            }
            if (!errors.isEmpty()) {
                throw new IOException("Failed to parse PSML from DB: " + (String)errors.get(0));
            }
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load content from DB for fragment {}", (Object)fragment, (Object)ex);
        }
    }

    void documentInfo(XMLWriter output) throws IOException {
        output.openElement("documentinfo");
        this.uri(output);
        try {
            Publication pub = DatabaseQuery.getPublicationByRootURI((Database)this.database, (URI)this.uri, (boolean)false);
            if (pub != null) {
                Publications.print(pub, new UniversalPrinter(new XMLOutputPrinter(output)));
            }
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load publication", (Throwable)ex);
        }
        if (XLinks.isVersion((XLink)this.version)) {
            output.openElement("versions");
            PSMLContentBuilder.version(this.version, output);
            output.closeElement();
        } else if (!this.originalVersion) {
            try {
                URIRule.LimitReached limit = new URIRule.LimitReached();
                ArrayList<XLink> versions = new ArrayList<XLink>();
                int page = 1;
                do {
                    versions.addAll(URIRule.getReleasesForURI(this.database, this.uri, null, page, 100, limit));
                    ++page;
                } while (limit.reached && versions.size() < 100);
                if (!versions.isEmpty()) {
                    output.openElement("versions");
                    if (limit.reached || versions.size() > 100) {
                        output.attribute("limitreached", "true");
                    }
                    for (int i = 0; i < versions.size() && i < 100; ++i) {
                        PSMLContentBuilder.version((XLink)versions.get(i), output);
                    }
                    output.closeElement();
                }
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load versions", (Throwable)ex);
            }
        }
        if (this.track && this.compareId > -1L) {
            output.openElement("compareto");
            if (this.compareId == 0L) {
                output.attribute(VERSION_ELEMENT, "original");
                if (this.uri.getDateCreated() != null) {
                    output.attribute("date", ISO8601.format((long)this.uri.getDateCreated().getTime(), (ISO8601)ISO8601.DATETIME));
                }
            } else {
                try {
                    XLink xl = DatabaseQuery.getXLinkById((Database)this.database, (Long)this.compareId);
                    if (xl != null) {
                        output.attribute(VERSION_ELEMENT, (String)(XLinks.isVersion((XLink)xl) && xl.getContentTitle() != null ? xl.getContentTitle() : "event:" + this.compareId));
                        output.attribute("versionid", xl.getId().toString());
                        if (xl.getDate() != null) {
                            output.attribute("date", ISO8601.format((long)xl.getDate().getTime(), (ISO8601)ISO8601.DATETIME));
                        }
                    }
                }
                catch (QueryFailedException ex) {
                    LOGGER.error("Failed to load compare version", (Throwable)ex);
                }
            }
            if (URIRule.isPSML(this.uri)) {
                try {
                    XLink structure = DatabaseQuery.getXLinkURIStructure((Database)this.database, (URI)this.uri, (Group)this.group, (Date)(this.compareId == 0L ? this.uri.getDateCreated() : null), (long)this.compareId, (boolean)false);
                    if (structure == null) {
                        StructureBuilder handler = new StructureBuilder();
                        File originalFile = new File(URIRule.getRealPath(this.uri.getPath()));
                        XMLHelpers.parse(new FileInputStream(originalFile), handler);
                        output.openElement("structure");
                        output.writeXML(handler.getStructureXML());
                        output.closeElement();
                    } else {
                        output.openElement("structure");
                        output.writeXML(((Content)structure.getContents().next()).getData());
                        output.closeElement();
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to load compare structure", (Throwable)ex);
                }
            }
            output.closeElement();
        }
        try {
            Collection<Long> reverseXRefs = this.getReverseXRefs("default");
            if (reverseXRefs != null && !reverseXRefs.isEmpty()) {
                output.openElement("reversexrefs");
                if (this.loadedReverseXRefs != null && this.loadedReverseXRefs.isLimitReached()) {
                    output.attribute("limitreached", "true");
                }
                for (Long reverse : reverseXRefs) {
                    XRef xref = new XRef(DatabaseQuery.getXLinkById((Database)this.database, (Long)reverse));
                    xref.reverseXRefToPSML(output, true);
                }
                output.closeElement();
            }
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load main reverse XRefs", (Throwable)ex);
        }
        output.closeElement();
    }

    public void uri(XMLWriter output) throws IOException {
        String doctype;
        output.openElement("uri", true);
        output.attribute(ID_ATTRIBUTE, this.uri.getId().toString());
        boolean external = URIs.isExternal((URI)this.uri);
        output.attribute("external", Boolean.toString(external));
        if (external) {
            if (this.uri.isArchived()) {
                output.attribute("archived", "true");
            }
            if (this.uri.isFolder()) {
                output.attribute("folder", "true");
            }
        } else if (URIRule.isInternalArchived(this.uri)) {
            output.attribute("archived", "true");
        }
        output.attribute("mediatype", this.uri.getType());
        if (this.uri.getSize() != null && this.uri.getSize() > 0L) {
            output.attribute("size", String.valueOf(this.uri.getSize()));
        }
        if (!Strings.isEmpty((String)(doctype = URIRule.getStyleConfig(this.uri)))) {
            output.attribute(external ? "urltype" : "documenttype", doctype);
        }
        if (this.uri.getDateCreated() != null) {
            output.attribute("created", ISO8601.format((long)this.uri.getDateCreated().getTime(), (ISO8601)ISO8601.DATETIME));
        }
        if (this.version != null && this.version.getDate() != null) {
            output.attribute("modified", ISO8601.format((long)this.version.getDate().getTime(), (ISO8601)ISO8601.DATETIME));
        } else if (!this.originalVersion && this.uri.getLastModified() != null) {
            output.attribute("modified", ISO8601.format((long)this.uri.getLastModified().getTime(), (ISO8601)ISO8601.DATETIME));
        }
        XLink xl = null;
        if (this.version != null || this.originalVersion) {
            Long id = this.version != null ? this.version.getId() : 0L;
            xl = URIRule.getURIXLink(this.uri, id, this.database);
        }
        if (xl != null) {
            List labels;
            String path;
            Map props = ObjectProperties.toMap((String)xl.getProperties());
            URL hosturl = null;
            if (props.containsKey("hosturl")) {
                try {
                    hosturl = new URL((String)((List)props.get("hosturl")).get(0));
                }
                catch (MalformedURLException ex) {
                    LOGGER.warn("Malformed hosturl on XLink ID {}", (Object)xl.getId());
                }
            }
            if (hosturl != null) {
                output.attribute("scheme", hosturl.getProtocol());
                output.attribute("host", hosturl.getHost());
                output.attribute("port", hosturl.getPort() == -1 ? Rules.getDefaultPort((String)hosturl.getProtocol()) : hosturl.getPort());
            } else {
                output.attribute("scheme", this.uri.getScheme());
                output.attribute("host", this.uri.getHost().getName());
                output.attribute("port", this.uri.getPort().toString());
            }
            if (props.containsKey("path") || props.containsKey("origpath")) {
                List p = props.containsKey("origpath") ? (List)props.get("origpath") : (List)props.get("path");
                path = p.isEmpty() ? this.uri.getPath() : (String)p.iterator().next();
            } else {
                path = URIRule.getURIPathForOutput(this.uri);
            }
            output.attribute("path", path);
            output.attribute("decodedpath", URLCoder.decode((String)path));
            String userTitle = xl.getContentTitle();
            if (userTitle != null && !userTitle.isEmpty()) {
                output.attribute("title", xl.getContentTitle());
            }
            if (props.containsKey("docid")) {
                output.attribute("docid", (String)((List)props.get("docid")).get(0));
            }
            if (external) {
                if (URIs.isURLPSSource((URI)this.uri)) {
                    output.attribute("source", "pageseeder");
                } else if (this.uri.getHost().isVirtual()) {
                    output.attribute("source", "virtual");
                }
            }
            if (userTitle != null && !userTitle.isEmpty()) {
                output.element("displaytitle", userTitle);
            } else if (path.indexOf(47) == -1) {
                output.element("displaytitle", path);
            } else {
                output.element("displaytitle", path.substring(path.lastIndexOf(47) + 1));
            }
            if (props.containsKey("description")) {
                output.element("description", (String)((List)props.get("description")).get(0));
            }
            if ((labels = (List)props.get("label")) != null) {
                StringBuilder labs = new StringBuilder();
                for (int i = 0; i < labels.size(); ++i) {
                    labs.append((String)labels.get(i)).append(i < labels.size() - 1 ? "," : "");
                }
                output.element(LABELS_ELEMENT, labs.toString());
            }
        } else {
            String labels;
            output.attribute("scheme", this.uri.getScheme());
            output.attribute("host", this.uri.getHost().getName());
            output.attribute("port", this.uri.getPort().toString());
            output.attribute("path", URIRule.getURIPathForOutput(this.uri));
            output.attribute("decodedpath", URIRule.getURIDecodedPathForOutput(this.uri));
            if (this.uri.getDocID() != null) {
                output.attribute("docid", this.uri.getDocID());
            }
            if (this.uri.getUserTitle() != null) {
                output.attribute("title", this.uri.getUserTitle());
            }
            output.element("displaytitle", this.uri.getDisplayTitle());
            if (this.uri.getDescription() != null) {
                output.element("description", this.uri.getDescription());
            }
            if ((labels = this.uri.getLabels()) != null) {
                output.element(LABELS_ELEMENT, labels);
            }
        }
        output.closeElement();
    }

    void fragmentInfo(XMLWriter output, FragmentDetailsLoader fragmentDetailsLoader) throws IOException {
        output.openElement("fragmentinfo");
        if (URIRule.isPSML(this.uri)) {
            String modified;
            XLink structure = null;
            try {
                structure = DatabaseQuery.getXLinkURIStructure((Database)this.database, (URI)this.uri, (Group)this.group, (Date)(this.version != null ? this.version.getDate() : (this.originalVersion ? this.uri.getDateCreated() : null)));
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load structure for URIID " + this.uri.getId(), (Throwable)ex);
            }
            if (structure != null && structure.getDate() != null) {
                if (structure.getDate().equals(this.uri.getDateCreated())) {
                    if (fragmentDetailsLoader != null && (modified = fragmentDetailsLoader.getStructureModifiedDate()) != null) {
                        output.attribute("structure-modified", modified);
                    }
                } else {
                    output.attribute("structure-modified", ISO8601.format((long)structure.getDate().getTime(), (ISO8601)ISO8601.DATETIME));
                }
            } else if (fragmentDetailsLoader != null && (modified = fragmentDetailsLoader.getStructureModifiedDate()) != null) {
                output.attribute("structure-modified", modified);
            }
        }
        ArrayList<String> alreadyDone = new ArrayList<String>();
        Collection locs = this.uri.getLocatorsCol();
        for (Locator loc : locs) {
            alreadyDone.add(loc.getFragment());
            if (!this.fragmentHasContent(loc.getFragment(), fragmentDetailsLoader) && (!"default".equals(loc.getFragment()) || this.compareId <= -1L)) continue;
            this.locator(loc, loc.getFragment(), fragmentDetailsLoader, true, output);
        }
        for (String fragment : fragmentDetailsLoader.getFragments()) {
            if (alreadyDone.contains(fragment)) continue;
            String locatorContent = fragmentDetailsLoader.getLocatorContent(fragment);
            String modified = fragmentDetailsLoader.getModifiedDate(fragment);
            if (locatorContent == null && modified == null && !this.track) continue;
            output.openElement("locator", true);
            output.attribute("fragment", fragment);
            if (modified != null) {
                output.attribute("modified", modified);
            }
            this.locatorEdits(fragment, output);
            output.writeXML(locatorContent);
            output.closeElement();
        }
        output.closeElement();
    }

    private boolean fragmentHasContent(String fragment, FragmentDetailsLoader loader) {
        if ("default".equals(fragment)) {
            return false;
        }
        XLink lastedit = this.loadLastEditFragmentFromDB(fragment, true);
        if (lastedit != null) {
            return true;
        }
        try {
            if (this.getReverseXRefs(fragment) != null) {
                return true;
            }
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load reverse xrefs", (Throwable)ex);
        }
        return loader.getFragmentContent(fragment) != null || loader.getModifiedDate(fragment) != null;
    }

    public void metadata(XMLWriter output, FragmentDetailsLoader loader) throws IOException {
        String locatorContent;
        String fragment = "default";
        Locator loc = null;
        Iterator i = this.uri.getLocators((Object)Predicates.predicateLocatorFragment((Database)this.database, (String)fragment));
        while (i.hasNext()) {
            Locator aloc = (Locator)i.next();
            if (!aloc.getFragment().equals(fragment)) continue;
            loc = aloc;
        }
        output.openElement("metadata", true);
        XLink lastedit = null;
        if (loc != null) {
            lastedit = this.loadLastEditFragmentFromDB(loc.getFragment(), false);
        }
        if (lastedit != null) {
            output.attribute("editid", String.valueOf(lastedit.getId()));
            output.attribute("modified", ISO8601.format((long)lastedit.getDate().getTime(), (ISO8601)ISO8601.DATETIME));
            if (URIs.isExternal((URI)this.uri) && lastedit.getModifiedDate() != null) {
                output.attribute("checked", ISO8601.format((long)lastedit.getModifiedDate().getTime(), (ISO8601)ISO8601.DATETIME));
            }
        }
        this.fragment(fragment, loader, true, false, output);
        if (lastedit != null) {
            Collection notes = null;
            try {
                notes = DatabaseQuery.getRepliesByGroupContentRoleDates((Database)this.database, (XLink)lastedit, (Long)this.group.getId(), (String[])new String[]{"Documentation-Note"}, null, null, null);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load replies to last edit as notes", (Throwable)ex);
            }
            if (notes != null && !notes.isEmpty()) {
                output.openElement("notes");
                for (XLink note : notes) {
                    PSMLContentBuilder.note(note, output);
                }
                output.closeElement();
            }
        } else if (loader != null && (locatorContent = loader.getLocatorContent(fragment)) != null) {
            output.writeXML(locatorContent);
        }
        output.closeElement();
    }

    public void locator(Locator loc, String fragment, FragmentDetailsLoader loader, boolean reversexrefs, XMLWriter output) throws IOException {
        output.openElement("locator", true);
        XLink lastedit = null;
        if (loc != null) {
            output.attribute(ID_ATTRIBUTE, String.valueOf(loc.getId()));
            lastedit = this.loadLastEditFragmentFromDB(loc.getFragment(), false);
        }
        output.attribute("fragment", fragment);
        if (lastedit != null) {
            if ("Documentation-Original".equals(lastedit.getContentRole())) {
                String modified = loader.getModifiedDate(fragment);
                if (modified != null) {
                    output.attribute("modified", modified);
                }
            } else {
                output.attribute("editid", String.valueOf(lastedit.getId()));
                output.attribute("modified", ISO8601.format((long)lastedit.getDate().getTime(), (ISO8601)ISO8601.DATETIME));
            }
            String labels = String.join((CharSequence)",", Labels.getLabels((XLink)lastedit));
            if (!Strings.isEmpty((String)labels)) {
                output.element(LABELS_ELEMENT, labels);
            }
            Collection notes = null;
            try {
                notes = DatabaseQuery.getRepliesByGroupContentRoleDates((Database)this.database, (XLink)lastedit, (Long)this.group.getId(), (String[])new String[]{"Documentation-Note"}, null, null, null);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load replies to last edit as notes", (Throwable)ex);
            }
            if (notes != null && !notes.isEmpty()) {
                output.openElement("notes");
                for (XLink note : notes) {
                    PSMLContentBuilder.note(note, output);
                }
                output.closeElement();
            }
        } else if (loader != null) {
            String locatorContent = loader.getLocatorContent(fragment);
            String modified = loader.getModifiedDate(fragment);
            if (modified != null) {
                output.attribute("modified", modified);
            }
            if (locatorContent != null) {
                output.writeXML(locatorContent);
            }
        }
        if (loc != null && reversexrefs) {
            try {
                Collection<Long> reverseXRefs = this.getReverseXRefs(fragment);
                if (reverseXRefs != null && !reverseXRefs.isEmpty()) {
                    output.openElement("reversexrefs");
                    for (Long reverse : reverseXRefs) {
                        XRef xref = new XRef(DatabaseQuery.getXLinkById((Database)this.database, (Long)reverse));
                        xref.reverseXRefToPSML(output, true);
                    }
                    output.closeElement();
                }
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to output reverse xrefs for fragment {}", (Object)loc.getFragment(), (Object)ex);
            }
        }
        this.locatorEdits(fragment, output);
        output.closeElement();
    }

    private void locatorEdits(String fragment, XMLWriter output) throws IOException {
        TrackedFragment tracked;
        if (this.track && (tracked = this.getTrackedSequence(fragment)) != null) {
            String labels;
            FragmentTracker.Edit edit;
            Object token;
            int i;
            output.openElement("edits");
            HashSet<FragmentTracker.Edit> uniqueEdits = new HashSet<FragmentTracker.Edit>();
            for (i = 0; i < tracked.forward.size(); ++i) {
                token = tracked.forward.get(i);
                edit = (FragmentTracker.Edit)((TrackedToken)token).getOrigin();
                if (edit == null || ((TrackedToken)token).getType() != XMLTokenType.TEXT && ((TrackedToken)token).getType() != XMLTokenType.ATTRIBUTE) continue;
                uniqueEdits.add(edit);
            }
            for (i = 0; i < tracked.reverse.size(); ++i) {
                token = tracked.reverse.get(i);
                edit = (FragmentTracker.Edit)((TrackedToken)token).getOrigin();
                if (edit == null || ((TrackedToken)token).getType() != XMLTokenType.TEXT && ((TrackedToken)token).getType() != XMLTokenType.ATTRIBUTE) continue;
                uniqueEdits.add(edit);
            }
            XMLOutputPrinter printer = new XMLOutputPrinter(output);
            uniqueEdits.forEach(e -> e.print(printer));
            ((OutputPrinter)printer).flush();
            output.closeElement();
            output.openElement("compare");
            if (tracked.previous != null && tracked.previous.getEdit() != null && !Strings.isEmpty((String)(labels = String.join((CharSequence)",", Labels.getLabels((XLink)tracked.previous.getEdit()))))) {
                output.element(LABELS_ELEMENT, labels);
            }
            output.openElement("diff");
            StringWriter psml = new StringWriter();
            TrackerXMLOutput<FragmentTracker.Edit> resultsOutput = new TrackerXMLOutput<FragmentTracker.Edit>(psml);
            resultsOutput.setReference(FragmentTracker::toOriginReference);
            resultsOutput.setTextFormat(FragmentTracker::toOriginAttributes);
            resultsOutput.setElement(Operator.DEL);
            try {
                resultsOutput.write(tracked.reverse);
            }
            catch (DiffException ex) {
                LOGGER.error("Failed to output diffX when tracking reverse document changes for fragment {} in document {}", new Object[]{fragment, this.uri.getId(), ex});
            }
            output.writeXML(psml.toString());
            output.closeElement();
            output.closeElement();
        }
    }

    public static void author(XLink xlink, XMLWriter output) throws IOException {
        output.openElement("author");
        Member member = xlink.getMember();
        if (member != null) {
            output.attribute(ID_ATTRIBUTE, String.valueOf(member.getId()));
            output.attribute("firstname", member.getFirstName());
            output.attribute("surname", member.getSurname());
            output.element("fullname", MemberRule.getFullName(member));
        } else {
            output.element("fullname", xlink.getAuthorName());
        }
        output.closeElement();
    }

    public static void note(XLink note, XMLWriter output) throws IOException {
        output.openElement("note");
        output.attribute("title", note.getContentTitle());
        output.attribute(ID_ATTRIBUTE, String.valueOf(note.getId()));
        output.attribute("modified", ISO8601.format((long)(note.getModifiedDate() == null ? note.getDate() : note.getModifiedDate()).getTime(), (ISO8601)ISO8601.DATETIME));
        PSMLContentBuilder.author(note, output);
        for (Content content : note.getContentsCol()) {
            output.element("content", content.getData());
        }
        String labels = String.join((CharSequence)",", Labels.getLabels((XLink)note));
        if (!labels.isEmpty()) {
            output.element(LABELS_ELEMENT, labels);
        }
        output.closeElement();
    }

    public static void note(XLink note, OutputPrinter out) {
        out.startObject("note");
        out.field("title", note.getContentTitle());
        out.field(ID_ATTRIBUTE, note.getId());
        out.field("modified", ISO8601.format((long)(note.getModifiedDate() == null ? note.getDate() : note.getModifiedDate()).getTime(), (ISO8601)ISO8601.DATETIME));
        if (note.getMember() != null) {
            Member author = note.getMember();
            out.startObject("author");
            out.field(ID_ATTRIBUTE, author.getId());
            out.field("firstname", author.getFirstName());
            out.field("surname", author.getSurname());
            out.field("fullname", MemberRule.getFullName(author), OutputPrinter.FieldOption.XML_ELEMENT);
            out.endObject();
        } else if (note.getAuthorName() != null) {
            out.startObject("author");
            out.field("fullname", note.getAuthorName(), OutputPrinter.FieldOption.XML_ELEMENT);
            out.endObject();
        }
        for (Content content : note.getContentsCol()) {
            out.field("content", content.getData(), OutputPrinter.FieldOption.XML_ELEMENT);
        }
        String[] labels = Labels.getLabels((XLink)note);
        if (labels.length > 0) {
            out.field(LABELS_ELEMENT, labels, OutputPrinter.FieldOption.XML_ELEMENT);
        }
        out.endObject();
    }

    public static void version(XLink theversion, XMLWriter output) throws IOException {
        output.openElement(VERSION_ELEMENT);
        output.attribute(ID_ATTRIBUTE, String.valueOf(theversion.getId()));
        output.attribute("name", theversion.getContentTitle());
        output.attribute("created", ISO8601.format((long)theversion.getDate().getTime(), (ISO8601)ISO8601.DATETIME));
        Collection att = theversion.getAttached();
        if (!att.isEmpty()) {
            output.attribute("publicationid", ((XLinkForAttachedXLink)att.iterator().next()).getAttachedXLink().getContentTitle());
        }
        PSMLContentBuilder.author(theversion, output);
        for (Content content : theversion.getContentsCol()) {
            String data = content.getData();
            if (data == null || data.isEmpty()) continue;
            output.element("description", content.getData());
        }
        String labels = String.join((CharSequence)",", Labels.getLabels((XLink)theversion));
        if (!labels.isEmpty()) {
            output.element(LABELS_ELEMENT, labels);
        }
        output.closeElement();
    }

    public @Nullable XLink loadLastEditFragmentFromDB(String fragment, boolean includeAnyDraft) {
        String key = fragment + "-" + includeAnyDraft;
        LoadedXLink loaded = this.fragmentsInTheDB.get(key);
        if (loaded == null) {
            loaded = new LoadedXLink();
            Date limitDate = this.version != null ? this.version.getDate() : (this.originalVersion ? this.uri.getDateCreated() : null);
            try {
                loaded.xl = DatabaseQuery.getXLinkByURIGroupLastEditFragmentDraftCreationBeforeStatusChangedAfter((Database)this.database, (URI)this.uri, (Group)this.group, (String)fragment, (boolean)true, (boolean)includeAnyDraft, (boolean)true, (Long)this.draftMemberId, (Date)limitDate, (Date)limitDate);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load fragment '{}' edits", (Object)fragment, (Object)ex);
            }
            this.fragmentsInTheDB.put(key, loaded);
            if (includeAnyDraft && (loaded.xl == null || !"Documentation-Draft".equals(loaded.xl.getStatus()))) {
                this.fragmentsInTheDB.put(fragment + "-false", loaded);
            }
        }
        return loaded.xl;
    }

    private void loadEditIDs() {
        if (this.fragmentEditIDs == null) {
            try {
                this.fragmentEditIDs = DatabaseQuery.getEditIDsFragmentsByURIGroup((Database)this.database, (URI)this.uri, (String)this.group.getName(), null, (int)-1);
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load document edits", (Throwable)ex);
            }
        }
    }

    private @Nullable TrackedFragment getTrackedSequence(String fragment) {
        if (this.fragmentTracking == null) {
            this.fragmentTracking = new HashMap<String, TrackedFragment>();
        }
        if (this.fragmentTracking.containsKey(fragment)) {
            return this.fragmentTracking.get(fragment);
        }
        this.loadEditIDs();
        List history = null;
        FragmentTracker.Edit previousEdit = null;
        if (this.fragmentEditIDs != null) {
            try {
                List<Long> ids = this.fragmentEditIDs.get(fragment);
                if (ids == null) {
                    ids = Collections.emptyList();
                }
                FragmentTracker tracker = new FragmentTracker(this.uri, fragment, this.group, this.database);
                history = tracker.loadEdits(ids, this.compareId, this.version == null ? -1L : this.version.getId()).stream().map(FragmentTracker::toTrackedContent).collect(Collectors.toList());
                previousEdit = tracker.getFirstEdit();
                this.editsTrackedCounter += history.size();
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Failed to load document edits", (Throwable)ex);
            }
        }
        if (this.editsTrackedCounter > 1000) {
            if (this.transaction != null) {
                try {
                    this.transaction.commitAndStart();
                }
                catch (CommitTransactionException | StartTransactionException ex) {
                    LOGGER.error("Failed to start/restart transaction", ex);
                }
            }
            this.editsTrackedCounter -= 1000;
        }
        if (!(history == null || (history.isEmpty() || "<fragment/>".equals(((TrackedContent)history.get(0)).getContent()) && history.size() <= 1) && (previousEdit == null || "<fragment/>".equals(previousEdit.getContent())))) {
            OriginTracker tracker = new OriginTracker();
            try {
                TrackedFragment tracked = new TrackedFragment();
                if (previousEdit != null) {
                    history.add(0, FragmentTracker.toTrackedContent(previousEdit));
                }
                tracked.reverse = tracker.trackReverse(history);
                tracked.forward = tracker.track(history, this.compareId <= 0L && this.trackOriginal);
                tracked.previous = previousEdit;
                this.fragmentTracking.put(fragment, tracked);
                return tracked;
            }
            catch (DiffException ex) {
                LOGGER.error("Failed to track changes for fragment {} in document {}", new Object[]{fragment, this.uri.getId(), ex});
            }
        }
        this.fragmentTracking.put(fragment, null);
        return null;
    }

    private static class TrackedFragment {
        private TrackedSequence<FragmentTracker.Edit> forward;
        private TrackedSequence<FragmentTracker.Edit> reverse;
        private FragmentTracker.Edit previous;

        private TrackedFragment() {
        }
    }

    public static interface FragmentDetailsLoader {
        public @Nullable String getFragmentContent(String var1);

        public @Nullable String getLocatorContent(String var1);

        public @Nullable String getLabels(String var1);

        public @Nullable String getModifiedDate(String var1);

        public @Nullable String getStructureModifiedDate();

        public Collection<String> getFragments();
    }

    private static final class XRefCreator
    extends DefaultHandler {
        private final Database database;
        private final Group group;
        private final List<XRef> xrefs;
        private @Nullable String labels;
        private boolean original;
        private final URI sourceURI;
        private final String sourceFragment;
        private final XMLWriter xml;
        private @Nullable XRef xref;
        private @Nullable XMLStringWriter xrefContent = null;

        XRefCreator(Database db, URI uri, String fragment, Group gp, List<XRef> xr, boolean orig, @Nullable String labels, XMLWriter output) {
            this.database = db;
            this.group = gp;
            this.xrefs = xr;
            this.sourceURI = uri;
            this.sourceFragment = fragment;
            this.labels = labels;
            this.original = orig;
            this.xml = output;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            this.xml.setPrefixMapping(uri, prefix);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String lname, String qname, Attributes atts) throws SAXException {
            if (this.xrefs != null && ("xref".equals(lname) || "blockxref".equals(lname) || "image".equals(lname) || "link".equals(lname))) {
                this.xref = new XRef(this.sourceURI, this.sourceFragment, atts, lname, false, false);
                this.xref.setAdd(false);
                this.xrefContent = new XMLStringWriter(XML.NamespaceAware.No);
                return;
            } else if (this.xrefContent != null) {
                this.xrefContent.openElement(lname, true);
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.xrefContent.attribute(atts.getLocalName(i), atts.getValue(i));
                }
                return;
            } else {
                try {
                    this.xml.openElement(Strings.isEmpty((String)uri) ? null : uri, lname, true);
                    for (int i = 0; i < atts.getLength(); ++i) {
                        this.xml.attribute(Strings.isEmpty((String)atts.getURI(i)) ? null : atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                    }
                    if (!PSMLContentUtils.isFragmentElement(lname)) return;
                    if (this.labels != null && !this.labels.isEmpty() && atts.getValue(PSMLContentBuilder.LABELS_ELEMENT) == null) {
                        this.xml.attribute(PSMLContentBuilder.LABELS_ELEMENT, this.labels);
                    }
                    this.labels = null;
                    return;
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to open element {}", (Object)lname, (Object)ex);
                    throw new SAXException("Failed to open element " + lname, ex);
                }
            }
        }

        @Override
        public void endElement(String uri, String lname, String qname) throws SAXException {
            if (this.xref != null && ("xref".equals(lname) || "blockxref".equals(lname) || "image".equals(lname) || "link".equals(lname))) {
                if (this.xrefContent != null) {
                    this.xref.setContent(this.xrefContent.toString());
                }
                try {
                    this.xref.retrieveTargetWithURIID(this.database);
                }
                catch (FoundationException ex) {
                    LOGGER.debug("Failed to resolve XRef/image with {}", (Object)ex.getMessage());
                }
                int index = this.xrefs.indexOf(this.xref);
                if (index >= 0) {
                    XRef found = this.xrefs.get(index);
                    this.xref.setXLink(found.getXLink());
                    found.setAdd(true);
                } else if (this.original) {
                    this.xref.setTargetUri(null);
                }
                try {
                    this.xref.xRefToPSML(this.xml, this.database, true, false);
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to output XRef", (Throwable)ex);
                    throw new SAXException("Failed to output XRef", ex);
                }
                this.xrefContent = null;
            } else if (this.xrefContent != null) {
                this.xrefContent.closeElement();
            } else {
                try {
                    this.xml.closeElement();
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to close element {}", (Object)lname, (Object)ex);
                    throw new SAXException("Failed to close element " + lname, ex);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.xrefContent != null) {
                this.xrefContent.writeText(ch, start, length);
            } else {
                try {
                    this.xml.writeText(ch, start, length);
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to write text", (Throwable)ex);
                    throw new SAXException("Failed to write text", ex);
                }
            }
        }
    }

    private static final class LoadedXLink {
        private @Nullable XLink xl = null;

        private LoadedXLink() {
        }
    }
}

