/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.base;

import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.common.UnforeseenException;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.properties.SettingsFile;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupForXLink;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Flags;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupProperties.class);
    private static final Map<String, Properties> CACHE = new ConcurrentHashMap<String, Properties>();

    private GroupProperties() {
    }

    public static Properties get(Database db, @Nullable Group grp) throws QueryFailedException, IOException {
        if (grp == null) {
            return (Properties)GroupProperties.getServerDefault(db).clone();
        }
        String grpName = grp.getName();
        Properties prop = GroupProperties.tryCache(grpName);
        if (prop != null) {
            return (Properties)prop.clone();
        }
        prop = GroupProperties.getInheritance(db, grp);
        prop.putAll((Map<?, ?>)GroupProperties.getOverwritten(db, grp));
        CACHE.put(grpName, prop);
        return (Properties)prop.clone();
    }

    public static Properties getInheritance(Database db, @Nullable Group grp) throws QueryFailedException, IOException {
        if (grp == null || grp.getName().equals(GlobalSettings.getGlobalTemplate())) {
            return (Properties)Settings.getProperties((SettingsFile)SettingsFile.GROUP).clone();
        }
        String grpName = grp.getName();
        if (grpName.indexOf(45) != -1) {
            String dadName = grpName.substring(0, grpName.lastIndexOf(45));
            Group dad = DatabaseQuery.getGroupByName((Database)db, (String)dadName);
            return GroupProperties.get(db, dad);
        }
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)GroupProperties.getServerDefault(db));
        File propFile = GroupProperties.getProjectPropertiesFile(grp.getOwnerDirectory());
        if (propFile != null) {
            try (FileInputStream in = new FileInputStream(propFile);){
                prop.load(in);
            }
        }
        return prop;
    }

    public static Properties getProject(Database db, @Nullable Group group) throws QueryFailedException, IOException {
        File propFile;
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)Settings.getProperties((SettingsFile)SettingsFile.PROJECT_DEFAULT));
        if (group == null) {
            return prop;
        }
        Group project = group;
        String projectName = group.getName();
        int i = projectName.indexOf(45);
        if (i != -1) {
            projectName = projectName.substring(0, i);
            project = DatabaseQuery.getGroupByName((Database)db, (String)projectName);
        }
        if (project != null && (propFile = GroupProperties.getProjectPropertiesFile(project.getOwnerDirectory())) != null) {
            try (FileInputStream in = new FileInputStream(propFile);){
                prop.load(in);
            }
        }
        return prop;
    }

    public static Properties getOverwritten(Database db, @Nullable Group grp) throws IOException, QueryFailedException {
        Properties props = new Properties();
        if (grp == null || grp.getFlags() == null || grp.getFlags().indexOf(118) == -1 || grp.getDefaultLocator() == null) {
            return props;
        }
        Iterator xlfls = grp.getDefaultLocator().getXLinksForLocator((Object)Predicates.predicateXLinkForLocatorContentRoleLike((Database)db, (String[])new String[]{"group-properties"}));
        while (xlfls.hasNext()) {
            LocatorForXLink xlfl = (LocatorForXLink)xlfls.next();
            Iterator contents = xlfl.getXLink().getContents();
            while (contents.hasNext()) {
                Content content = (Content)contents.next();
                if (content.getData() == null) continue;
                props.load(new ByteArrayInputStream(content.getData().getBytes(StandardCharsets.UTF_8)));
            }
        }
        Properties finalProps = new Properties();
        Properties confProps = Settings.getProperties((SettingsFile)SettingsFile.GROUP);
        Properties projProps = GroupProperties.getProject(db, grp);
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            if (!confProps.containsKey(prop.getKey()) || projProps.containsKey(prop.getKey())) continue;
            finalProps.put(prop.getKey(), prop.getValue());
        }
        return finalProps;
    }

    public static Properties getServerDefault(Database db) throws QueryFailedException, IOException {
        Properties prop = (Properties)Settings.getProperties((SettingsFile)SettingsFile.GROUP).clone();
        String global = GlobalSettings.getGlobalTemplate();
        if (!Strings.isEmpty((String)global)) {
            Properties globalProp = GroupProperties.tryCache(global);
            if (globalProp != null) {
                return (Properties)globalProp.clone();
            }
            Group project = DatabaseQuery.getGroupByName((Database)db, (String)global);
            if (project != null) {
                prop.putAll((Map<?, ?>)GroupProperties.getOverwritten(db, project));
            }
            CACHE.put(global, prop);
        }
        return prop;
    }

    public static void set(Database db, Group grp, Properties props) throws IOException, DatabaseException {
        GroupProperties.clearCache(grp);
        XLink xl = null;
        Locator loc = grp.getDefaultLocator();
        if (loc == null) {
            loc = Locator.create((Database)db);
            loc = loc.insert(db);
            grp.setDefaultLocator(loc);
        }
        Iterator xlfls = loc.getXLinksForLocator((Object)Predicates.predicateXLinkForLocatorContentRoleLike((Database)db, (String[])new String[]{"group-properties"}));
        while (xl == null && xlfls.hasNext()) {
            LocatorForXLink xlfl = (LocatorForXLink)xlfls.next();
            xl = xlfl.getXLink();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ByteArrayOutputStream byteArrayOutputStream = bos;){
            props.store(bos, null);
        }
        catch (IOException ex) {
            throw new UnforeseenException((Throwable)ex);
        }
        if (xl == null) {
            xl = XLink.create((Database)db);
            xl.setModeratorOnly(Boolean.FALSE);
            xl.setAccepted(Boolean.FALSE);
            xl.setAuthorOnly(Boolean.FALSE);
            xl.setContentRole("group-properties");
            Content content = Content.create((Database)db);
            content.setData(bos.toString(StandardCharsets.UTF_8));
            xl.addContents(content);
            xl = xl.insert(db);
            LocatorRule.addXLinkToLocator(db, xl, loc);
            GroupForXLink gfx = GroupForXLink.create((Database)db);
            gfx.setGroup(grp);
            xl.addGroupsForXLink(gfx);
            gfx = gfx.insert(db);
        } else {
            Content content;
            Iterator contents = xl.getContents();
            if (contents.hasNext()) {
                content = (Content)contents.next();
                content.setData(bos.toString(StandardCharsets.UTF_8));
            } else {
                content = Content.create((Database)db);
                content.setData(bos.toString(StandardCharsets.UTF_8));
                xl.addContents(content);
            }
            boolean alreadythere = xl.getGroupsForXLink((Object)Predicates.predicateGroupsForXLinkByGroups((Database)db, Collections.singleton(grp.getName()))).hasNext();
            if (!alreadythere) {
                GroupForXLink gfx = GroupForXLink.create((Database)db);
                gfx.setGroup(grp);
                xl.addGroupsForXLink(gfx);
                gfx = gfx.insert(db);
            }
        }
    }

    public static void remove(Database db, Group grp) {
        LocatorForXLink lxl = null;
        if (grp.getDefaultLocator() == null) {
            return;
        }
        Iterator xlfls = grp.getDefaultLocator().getXLinksForLocator((Object)Predicates.predicateXLinkForLocatorContentRoleLike((Database)db, (String[])new String[]{"group-properties"}));
        while (lxl == null && xlfls.hasNext()) {
            lxl = (LocatorForXLink)xlfls.next();
        }
        if (lxl == null) {
            return;
        }
        XLink xl = lxl.getXLink();
        if (xl != null) {
            xl.removeReplies(xl);
        }
        grp.getDefaultLocator().removeXLinksForLocator(lxl);
        grp.setFlags(Flags.remove((String)grp.getFlags(), (char)'v'));
        GroupProperties.clearCache(grp);
    }

    public static void clearCache() {
        CACHE.clear();
    }

    private static @Nullable Properties tryCache(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return CACHE.get(name);
    }

    public static void clearCache(Database db, String name) throws QueryFailedException {
        Group project = DatabaseQuery.getGroupByName((Database)db, (String)name);
        if (project != null) {
            GroupProperties.clearCache(project);
        }
    }

    public static void clearCache(Group group) {
        String name = group.getName();
        if (name.equals(GlobalSettings.getGlobalTemplate())) {
            CACHE.clear();
            return;
        }
        CACHE.remove(name);
        if (GroupRule.isProject(group)) {
            String projectStart = name + "-";
            ArrayList<String> toremove = new ArrayList<String>();
            for (String grpname : CACHE.keySet()) {
                if (!grpname.startsWith(projectStart)) continue;
                toremove.add(grpname);
            }
            for (String grpname : toremove) {
                CACHE.remove(grpname);
            }
        }
    }

    public static @Nullable File getProjectPropertiesFile(@Nullable String owner) throws IOException {
        String ownerDir = owner == null ? GlobalSettings.getGlobalTemplate() : owner;
        File f = null;
        if (ownerDir != null) {
            String path = "WEB-INF" + File.separator + "config" + File.separator + "template" + File.separator + ownerDir + File.separator + "config" + File.separator + "project.properties";
            f = GroupProperties.descendantFile(new File(Settings.getContextPath()), path);
            if (!f.exists() || !f.isFile()) {
                f = null;
            }
        }
        return f;
    }

    private static File descendantFile(File base, String path) throws IOException {
        File descendant = new File(base, path);
        if (!descendant.getCanonicalPath().startsWith(base.getCanonicalPath())) {
            LOGGER.error("Path results in a file outside base folder: {}", (Object)path);
            throw new IOException("Path results in a file outside base folder");
        }
        return descendant;
    }

    public static void print(@Nullable Group group, Database db, OutputPrinter out) throws IOException, QueryFailedException {
        Properties local = GroupProperties.getOverwritten(db, group);
        Properties project = GroupProperties.getProject(db, group);
        Properties allProps = GroupProperties.get(db, group);
        Properties inherited = GroupProperties.getInheritance(db, group);
        out.startCollection("properties");
        for (String name : allProps.stringPropertyNames()) {
            out.startObject("property");
            out.field("name", name);
            out.field("value", allProps.getProperty(name));
            out.field("source", GroupProperties.toSource(local, project, name));
            String inherit = inherited.getProperty(name);
            if (inherit != null) {
                out.field("inherit", inherit);
            }
            out.endObject();
        }
        out.endCollection();
    }

    private static String toSource(Properties local, Properties project, String name) {
        if (local.containsKey(name)) {
            return "local";
        }
        return project.containsKey(name) ? "project" : "inherit";
    }
}

