/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.xmlwriter.XMLWriter;

public final class WildcardParameter
implements SearchParameter {
    private final Term _term;

    public WildcardParameter(String field, String value) throws NullPointerException {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value.indexOf(63) == -1 && value.indexOf(42) == -1) {
            throw new IllegalArgumentException("value");
        }
        this._term = new Term(field, value);
    }

    public WildcardParameter(Term term) throws NullPointerException {
        if (term == null) {
            throw new NullPointerException("term");
        }
        if (term.text().indexOf(63) == -1 && term.text().indexOf(42) == -1) {
            throw new IllegalArgumentException("value");
        }
        this._term = term;
    }

    @Override
    public boolean isEmpty() {
        return this._term.field().isEmpty() || this._term.text().isEmpty();
    }

    @Override
    public Query toQuery() {
        if (this.isEmpty()) {
            return null;
        }
        return new WildcardQuery(this._term);
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("wildcard-parameter");
        xml.attribute("is-empty", Boolean.toString(this.isEmpty()));
        if (!this.isEmpty()) {
            xml.element("field", this._term.field());
            xml.element("prefix", this._term.text());
        }
        xml.closeElement();
    }

    public String toString() {
        return this._term.toString();
    }
}

