/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.xmlwriter.XMLWriter;

public final class PrefixParameter
implements SearchParameter {
    private final Term _prefix;

    public PrefixParameter(String field, String prefix) throws NullPointerException {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix");
        }
        this._prefix = new Term(field, prefix);
    }

    public PrefixParameter(Term prefix) throws NullPointerException {
        if (prefix == null) {
            throw new NullPointerException("prefix");
        }
        this._prefix = prefix;
    }

    @Override
    public boolean isEmpty() {
        return this._prefix.field().isEmpty() || this._prefix.text().isEmpty();
    }

    public Term prefix() {
        return this._prefix;
    }

    @Override
    public Query toQuery() {
        if (this.isEmpty()) {
            return null;
        }
        return new PrefixQuery(this._prefix);
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("prefix-parameter");
        xml.attribute("is-empty", Boolean.toString(this.isEmpty()));
        if (!this.isEmpty()) {
            xml.element("field", this._prefix.field());
            xml.element("prefix", this._prefix.text());
        }
        xml.closeElement();
    }

    public String toString() {
        return this._prefix.toString();
    }
}

