/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.search.Fields;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class Predicate
implements SearchParameter,
XMLWritable {
    private final String _predicate;
    private final Map<String, Float> _fields;
    private Query _query = null;

    Predicate(Map<String, Float> fields, String predicate) throws NullPointerException {
        if (fields == null) {
            throw new NullPointerException("fields");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        this._fields = fields;
        this._predicate = predicate;
    }

    public Collection<String> fields() {
        return this._fields.keySet();
    }

    public String predicate() {
        return this._predicate;
    }

    public float getBoost(String field) {
        Float boost = this._fields.get(field);
        return boost != null ? boost.floatValue() : 1.0f;
    }

    @Override
    public boolean isEmpty() {
        return this._predicate.isEmpty() || this._fields.isEmpty();
    }

    private void compute(Analyzer analyzer) throws ParseException {
        String[] fields = this._fields.keySet().toArray(new String[0]);
        MultiFieldQueryParser parser = new MultiFieldQueryParser(fields, analyzer);
        this._query = parser.parse(this._predicate);
    }

    private void compute() throws ParseException {
        this.compute((Analyzer)new StandardAnalyzer());
    }

    @Override
    public Query toQuery() throws IllegalStateException {
        if (this.isEmpty()) {
            return null;
        }
        if (this._query == null) {
            throw new IllegalStateException("Query has not been computed - call compute(Analyzer)");
        }
        return this._query;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("predicate", true);
        xml.attribute("is-empty", Boolean.toString(this.isEmpty()));
        if (this._query != null) {
            xml.attribute("query", this._query.toString());
        }
        for (Map.Entry<String, Float> field : this._fields.entrySet()) {
            xml.openElement("field");
            Float boost = field.getValue();
            xml.attribute("boost", boost != null ? boost.toString() : "1.0");
            xml.writeText(field.getKey());
            xml.closeElement();
        }
        xml.element("text", this._predicate);
        xml.closeElement();
    }

    public String toString() {
        return this._predicate + " in " + this._fields.entrySet();
    }

    public static Predicate newPredicate(String field, String predicate, Analyzer analyzer) throws ParseException {
        Map<String, Float> fields = Collections.singletonMap(field, Float.valueOf(1.0f));
        Predicate q = new Predicate(fields, predicate);
        q.compute(analyzer);
        return q;
    }

    public static Predicate newPredicate(List<String> fields, String predicate, Analyzer analyzer) throws ParseException {
        List<String> names = Fields.filterNames(fields);
        Map<String, Float> map = Fields.asBoostMap(names);
        Predicate q = new Predicate(map, predicate);
        q.compute(analyzer);
        return q;
    }

    public static Predicate newPredicate(Map<String, Float> fields, String predicate, Analyzer analyzer) throws ParseException {
        Predicate q = new Predicate(fields, predicate);
        q.compute(analyzer);
        return q;
    }

    public static Predicate newPredicate(List<String> fields, String predicate) throws ParseException {
        List<String> names = Fields.filterNames(fields);
        Map<String, Float> map = Fields.asBoostMap(names);
        Predicate q = new Predicate(map, predicate);
        q.compute();
        return q;
    }

    public static Predicate newPredicate(Map<String, Float> fields, String predicate) throws ParseException {
        Predicate q = new Predicate(fields, predicate);
        q.compute();
        return q;
    }
}

