/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.search.Query;
import org.pageseeder.flint.catalog.Catalog;
import org.pageseeder.flint.catalog.Catalogs;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public class NumberParameter<T extends Number>
implements SearchParameter {
    private final String _field;
    private final T _value;
    private volatile Query _query;

    public NumberParameter(String field, T value) {
        if (field == null) {
            throw new NullPointerException("field");
        }
        this._field = field;
        this._value = value;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("number-parameter", false);
        xml.attribute("field", this._field);
        if (this._value != null) {
            xml.attribute("type", this._value.getClass().getName().replaceFirst("^(.+\\.)", "").toLowerCase());
            xml.attribute("value", String.valueOf(this._value));
        }
        xml.closeElement();
    }

    @Override
    public boolean isEmpty() {
        return this._value == null;
    }

    @Override
    public Query toQuery() {
        if (this._value == null) {
            return null;
        }
        if (this._query == null) {
            if (this._value instanceof Float) {
                this._query = FloatPoint.newExactQuery((String)this._field, (float)((Float)this._value).floatValue());
            } else if (this._value instanceof Double) {
                this._query = DoublePoint.newExactQuery((String)this._field, (double)((Double)this._value));
            } else if (this._value instanceof Integer) {
                this._query = IntPoint.newExactQuery((String)this._field, (int)((Integer)this._value));
            } else if (this._value instanceof Long) {
                this._query = LongPoint.newExactQuery((String)this._field, (long)((Long)this._value));
            }
        }
        return this._query;
    }

    public static NumberParameter<Double> newDoubleParameter(String field, Double value) {
        return new NumberParameter<Double>(field, value);
    }

    public static NumberParameter<Float> newFloatParameter(String field, Float value) {
        return new NumberParameter<Float>(field, value);
    }

    public static NumberParameter<Integer> newIntParameter(String field, Integer value) {
        return new NumberParameter<Integer>(field, value);
    }

    public static NumberParameter<Long> newLongParameter(String field, Long value) {
        return new NumberParameter<Long>(field, value);
    }

    public static NumberParameter<?> newNumberParameter(String field, String catalog, Number value) {
        Catalog thecatalog = Catalogs.getCatalog((String)catalog);
        if (thecatalog == null) {
            return null;
        }
        FlintField.NumericType nt = thecatalog.getNumericType(field);
        if (nt == null) {
            return null;
        }
        switch (nt) {
            case DOUBLE: {
                return NumberParameter.newDoubleParameter(field, (Double)value);
            }
            case FLOAT: {
                return NumberParameter.newFloatParameter(field, (Float)value);
            }
            case INT: {
                return NumberParameter.newIntParameter(field, (Integer)value);
            }
            case LONG: {
                return NumberParameter.newLongParameter(field, (Long)value);
            }
        }
        return null;
    }
}

