/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.query;

import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.pageseeder.flint.lucene.query.SearchParameter;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.xmlwriter.XMLWriter;

public final class DateParameter
implements SearchParameter {
    private final String _field;
    private final OffsetDateTime _from;
    private final OffsetDateTime _to;
    private final DateTools.Resolution _resolution;
    private final boolean _minInclusive;
    private final boolean _maxInclusive;
    private final boolean _numeric;
    private volatile Query _query;

    public DateParameter(String field, DateTools.Resolution resolution, boolean numeric) {
        this(field, null, (OffsetDateTime)null, true, true, resolution, numeric);
    }

    public DateParameter(String field, Date exactMatch, DateTools.Resolution resolution, boolean numeric) {
        this(field, exactMatch, exactMatch, true, true, resolution, numeric);
    }

    public DateParameter(String field, Date from, Date to, DateTools.Resolution resolution, boolean numeric) {
        this(field, from, to, true, true, resolution, numeric);
    }

    public DateParameter(String field, Date from, Date to, boolean withMin, boolean withMax, DateTools.Resolution resolution, boolean numeric) {
        this(field, from == null ? null : OffsetDateTime.ofInstant(Instant.ofEpochMilli(from.getTime()), ZoneOffset.UTC), to == null ? null : OffsetDateTime.ofInstant(Instant.ofEpochMilli(to.getTime()), ZoneOffset.UTC), withMin, withMax, resolution, numeric);
    }

    public DateParameter(String field, OffsetDateTime exactMatch, DateTools.Resolution resolution, boolean numeric) {
        this(field, exactMatch, exactMatch, true, true, resolution, numeric);
    }

    public DateParameter(String field, OffsetDateTime from, OffsetDateTime to, DateTools.Resolution resolution, boolean numeric) {
        this(field, from, to, true, true, resolution, numeric);
    }

    public DateParameter(String field, OffsetDateTime from, OffsetDateTime to, boolean withMin, boolean withMax, DateTools.Resolution resolution, boolean numeric) {
        if (field == null) {
            throw new NullPointerException("field");
        }
        if (resolution == null) {
            throw new NullPointerException("resolution");
        }
        this._field = field;
        this._from = from;
        this._to = to;
        this._minInclusive = withMin;
        this._maxInclusive = withMax;
        this._resolution = resolution;
        this._numeric = numeric;
    }

    public Date from() {
        return this._from != null ? new Date(this._from.toInstant().toEpochMilli()) : null;
    }

    public Date to() {
        return this._to != null ? new Date(this._to.toInstant().toEpochMilli()) : null;
    }

    public OffsetDateTime fromOffsetDateTime() {
        return this._from;
    }

    public OffsetDateTime toOffsetDateTime() {
        return this._to;
    }

    public String field() {
        return this._field;
    }

    @Override
    public boolean isEmpty() {
        return this._from == null && this._to == null;
    }

    public boolean isMaxIncluded() {
        return this._maxInclusive;
    }

    public boolean isMinIncluded() {
        return this._minInclusive;
    }

    @Override
    public Query toQuery() {
        if (this._query == null) {
            this._query = this._from == null && this._to == null ? new TermQuery(new Term(this._field, "")) : (this._numeric ? DateParameter.toNumericRangeQuery(this._field, this._from, this._to, this._minInclusive, this._maxInclusive, this._resolution) : DateParameter.toTermRangeQuery(this._field, this._from, this._to, this._minInclusive, this._maxInclusive, this._resolution));
        }
        return this._query;
    }

    public void toXML(XMLWriter xml) throws IOException {
        boolean exactMatch = this._from != null && this._from.equals(this._to);
        xml.openElement(exactMatch ? "date-parameter" : "date-range", false);
        xml.attribute("field", this._field);
        if (this._from == null && this._to == null) {
            xml.attribute("value", "");
        } else if (exactMatch) {
            xml.attribute("value", Dates.format(this._from, this._resolution));
        } else {
            if (this._from != null) {
                xml.attribute("from", Dates.format(this._from, this._resolution));
                xml.attribute("from-included", Boolean.toString(this._minInclusive));
            }
            if (this._to != null) {
                xml.attribute("to", Dates.format(this._to, this._resolution));
                xml.attribute("to-included", Boolean.toString(this._maxInclusive));
            }
        }
        xml.closeElement();
    }

    public String toString() {
        Query q = this.toQuery();
        return q == null ? "[empty]" : q.toString();
    }

    private static TermRangeQuery toTermRangeQuery(String field, OffsetDateTime from, OffsetDateTime to, boolean withMin, boolean withMax, DateTools.Resolution resolution) {
        BytesRef min = from != null ? new BytesRef(Dates.toString(from, resolution).getBytes()) : null;
        BytesRef max = to != null ? new BytesRef(Dates.toString(to, resolution).getBytes()) : null;
        return new TermRangeQuery(field, min, max, withMin, withMax);
    }

    private static Query toNumericRangeQuery(String field, OffsetDateTime from, OffsetDateTime to, boolean withMin, boolean withMax, DateTools.Resolution resolution) {
        Number max;
        Number min = from != null ? (Number)Dates.toNumber(from, resolution) : (Number)null;
        Number number = max = to != null ? (Number)Dates.toNumber(to, resolution) : (Number)null;
        if (min instanceof Long || min == null && max instanceof Long) {
            long minLong;
            long l = min == null ? Long.MIN_VALUE : (minLong = withMin ? (Long)min : Math.addExact((Long)min, -1L));
            long maxLong = max == null ? Long.MAX_VALUE : (withMax ? (Long)max : Math.addExact((Long)max, 1L));
            return LongPoint.newRangeQuery((String)field, (long)minLong, (long)maxLong);
        }
        if (min instanceof Integer || min == null && max instanceof Integer) {
            int minLong;
            int n = min == null ? Integer.MIN_VALUE : (minLong = withMin ? (Integer)min : Math.addExact((Integer)min, 1));
            int maxLong = max == null ? Integer.MAX_VALUE : (withMax ? (Integer)max : Math.addExact((Integer)max, -1));
            return IntPoint.newRangeQuery((String)field, (int)minLong, (int)maxLong);
        }
        return null;
    }
}

