/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene.facet;

import java.io.IOException;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.Date;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.pageseeder.flint.lucene.facet.FlexibleIntervalFacet;
import org.pageseeder.flint.lucene.query.DateParameter;
import org.pageseeder.flint.lucene.util.Beta;
import org.pageseeder.flint.lucene.util.Dates;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class DateIntervalFacet
extends FlexibleIntervalFacet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateIntervalFacet.class);
    private final DateTools.Resolution _resolution;
    private final Period _intervalDate;
    private final Duration _intervalTime;
    private final OffsetDateTime _start;
    private final OffsetDateTime _end;

    private DateIntervalFacet(String name, OffsetDateTime start, OffsetDateTime end, int maxIntervals, DateTools.Resolution resolution, Period p, Duration d, boolean includeMin, boolean includeLastMax) {
        super(name, Dates.toString(start, resolution), Dates.toString(end, resolution), includeMin, includeLastMax, maxIntervals);
        this._start = start;
        this._end = end;
        this._resolution = resolution;
        this._intervalDate = p;
        this._intervalTime = d;
    }

    @Override
    public String formattedStart() {
        try {
            return Dates.format(DateTools.stringToDate((String)this.start()), this._resolution);
        }
        catch (ParseException ex) {
            LOGGER.warn("Ignoring invalid facet start {} for field {}", new Object[]{this.start(), this.name(), ex});
            return super.start();
        }
    }

    @Override
    public String formattedEnd() {
        try {
            return Dates.format(DateTools.stringToDate((String)this.end()), this._resolution);
        }
        catch (ParseException ex) {
            LOGGER.warn("Ignoring invalid facet end {} for field {}", new Object[]{this.end(), this.name(), ex});
            return super.start();
        }
    }

    public DateTools.Resolution getResolution() {
        return this._resolution;
    }

    @Override
    protected Query termToQuery(Term t) {
        try {
            if (t.text().isEmpty()) {
                return new TermQuery(t);
            }
            Date d = DateTools.stringToDate((String)t.text());
            return new DateParameter(this.name(), d, this._resolution, false).toQuery();
        }
        catch (ParseException ex) {
            LOGGER.warn("Ignoring invalid facet date {} for field {}", new Object[]{t.text(), this.name(), ex});
            return new TermQuery(t);
        }
    }

    @Override
    public String getType() {
        return "date-interval";
    }

    @Override
    protected FlexibleIntervalFacet.Interval findInterval(Term t) {
        Date d;
        if (t == null) {
            return null;
        }
        try {
            d = DateTools.stringToDate((String)t.text());
        }
        catch (ParseException ex) {
            LOGGER.warn("Ignoring invalid facet date {} for field {}", new Object[]{t.text(), this.name(), ex});
            return null;
        }
        return this.findInterval(OffsetDateTime.ofInstant(Instant.ofEpochMilli(d.getTime()), ZoneId.of("GMT")));
    }

    private FlexibleIntervalFacet.Interval findInterval(OffsetDateTime date) {
        boolean forward = date.isAfter(this._start);
        OffsetDateTime from = this._start;
        while (true) {
            boolean upperLimit;
            OffsetDateTime upper;
            OffsetDateTime to = this.next(from, forward);
            OffsetDateTime lower = forward ? from : to;
            OffsetDateTime offsetDateTime = upper = forward ? to : from;
            if (this._end != null && (lower.isAfter(this._end) || lower.equals(this._end) || upper.isBefore(this._start) || upper.equals(this._start))) {
                return null;
            }
            boolean includeMax = this._end != null && to.equals(this.next(to, forward)) ? this.includeLastUpper() : !this.includeLower();
            boolean lowerLimit = date.isAfter(lower) || this.includeLower() && date.equals(lower);
            boolean bl = upperLimit = date.isBefore(upper) || includeMax && date.equals(upper);
            if (lowerLimit && upperLimit) {
                return FlexibleIntervalFacet.Interval.dateInterval(new Date(lower.toEpochSecond() * 1000L), this.includeLower(), new Date(upper.toEpochSecond() * 1000L), includeMax, this._resolution);
            }
            if (forward && upperLimit) {
                return null;
            }
            if (!forward && lowerLimit) {
                return null;
            }
            if (from.equals(to)) {
                return null;
            }
            from = to;
        }
    }

    private OffsetDateTime next(OffsetDateTime from, boolean forward) {
        OffsetDateTime to;
        if (forward) {
            to = this._intervalDate == null ? from : from.plus(this._intervalDate);
            OffsetDateTime offsetDateTime = to = this._intervalTime == null ? to : to.plus(this._intervalTime);
            if (this._end != null && to.isAfter(this._end)) {
                to = this._end;
            }
        } else {
            to = this._intervalDate == null ? from : from.minus(this._intervalDate);
            OffsetDateTime offsetDateTime = to = this._intervalTime == null ? to : to.minus(this._intervalTime);
            if (this._end != null && to.isBefore(this._start)) {
                to = this._start;
            }
        }
        return to;
    }

    @Override
    protected void intervalToXML(FlexibleIntervalFacet.Interval interval, int cardinality, XMLWriter xml) throws IOException {
        try {
            String fmin = interval.getMin() == null ? null : Dates.format(DateTools.stringToDate((String)interval.getMin()), this._resolution);
            String fmax = interval.getMax() == null ? null : Dates.format(DateTools.stringToDate((String)interval.getMax()), this._resolution);
            Dates.dateRangeToXML("interval", fmin, fmax, interval.includeMin(), interval.includeMax(), cardinality, xml);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public static class Builder {
        private OffsetDateTime start = null;
        private OffsetDateTime end = null;
        private boolean includeMin = true;
        private boolean includeLastMax = true;
        private Period intervalDate = null;
        private Duration intervalTime = null;
        private DateTools.Resolution resolution = null;
        private String name = null;
        private int maxIntervals = -1;

        public Builder resolution(DateTools.Resolution res) {
            this.resolution = res;
            return this;
        }

        public Builder name(String n) {
            this.name = n;
            return this;
        }

        public Builder includeLastMax(boolean include) {
            this.includeLastMax = include;
            return this;
        }

        public Builder includeMin(boolean include) {
            this.includeMin = include;
            return this;
        }

        public Builder intervalDate(Period p) {
            this.intervalDate = p;
            return this;
        }

        public Builder intervalTime(Duration d) {
            this.intervalTime = d;
            return this;
        }

        public Builder maxIntervals(int max) {
            this.maxIntervals = max;
            return this;
        }

        public Builder start(Date startDate) {
            this.start = OffsetDateTime.ofInstant(Instant.ofEpochMilli(startDate.getTime()), ZoneId.of("GMT"));
            return this;
        }

        public Builder end(OffsetDateTime endDate) {
            this.end = endDate;
            return this;
        }

        public Builder end(Date endDate) {
            this.end = OffsetDateTime.ofInstant(Instant.ofEpochMilli(endDate.getTime()), ZoneId.of("GMT"));
            return this;
        }

        public Builder start(OffsetDateTime startDate) {
            this.start = startDate;
            return this;
        }

        public DateIntervalFacet build() {
            if (this.name == null) {
                throw new IllegalStateException("Must have a field name");
            }
            if (this.resolution == null) {
                throw new IllegalStateException("Must have a resolution");
            }
            if (this.start == null) {
                throw new IllegalStateException("Must have a start date");
            }
            if (this.intervalTime == null && this.intervalDate == null) {
                throw new IllegalStateException("Must have a valid interval (period or duration)");
            }
            return new DateIntervalFacet(this.name, this.start, this.end, this.maxIntervals, this.resolution, this.intervalDate, this.intervalTime, this.includeMin, this.includeLastMax);
        }
    }
}

