/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.lucene;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.IndexIO;
import org.pageseeder.flint.lucene.LuceneIndexIO;

public class LuceneIndex
extends Index {
    private final Directory _directory;
    private final Analyzer _analyzer;
    private final IndexIO _io;

    public LuceneIndex(String id, File dir, Analyzer analyzer) throws IOException, IndexException {
        this(id, (Directory)FSDirectory.open((Path)dir.toPath()), analyzer);
    }

    public LuceneIndex(String id, Directory dir, Analyzer analyzer) throws IndexException {
        super(id);
        this._directory = dir;
        this._analyzer = analyzer;
        this._io = new LuceneIndexIO(this._directory, this._analyzer);
    }

    public Analyzer getAnalyzer() {
        return this._analyzer;
    }

    public final Directory getIndexDirectory() {
        return this._directory;
    }

    public IndexIO getIndexIO() {
        return this._io;
    }
}

