/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.docx.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.pageseeder.docx.DOCXException;

public class Files {
    private Files() {
    }

    public static void copy(File from, File to) throws IOException {
        Files.ensureDirectoryExists(to.getParentFile());
        if (!to.exists() && !to.createNewFile()) {
            throw new IOException("Unable to create file: " + to.getName());
        }
        try (FileChannel source = new FileInputStream(from).getChannel();
             FileChannel destination = new FileOutputStream(to).getChannel();){
            long size = source.size();
            for (long position = 0L; position < size; position += destination.transferFrom(source, position, size)) {
            }
            destination.transferFrom(source, 0L, size);
        }
    }

    public static File descendantFile(File base, String path) throws IOException {
        File descendant = new File(base, path);
        if (!descendant.getCanonicalPath().startsWith(base.getCanonicalPath())) {
            throw new IOException("Path results in a file outside base folder");
        }
        return descendant;
    }

    public static void ensureDirectoryExists(File directory) throws DOCXException {
        boolean done;
        if (!directory.exists() && !(done = directory.mkdirs())) {
            throw new DOCXException("Unable to create target directory for preprocessor");
        }
    }

    public static void renameFiles(File dir, String prefix) throws IOException {
        File[] children;
        if (dir.exists() && dir.isDirectory() && (children = dir.listFiles()) != null) {
            for (File child : children) {
                if (child.renameTo(new File(dir, prefix + child.getName()))) continue;
                throw new IOException("Unable to rename file: " + child.getName());
            }
        }
    }

    public static void copyDirectory(File source, File target) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is null");
        }
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        if (source.isDirectory()) {
            String[] children;
            if (!target.exists()) {
                target.mkdir();
            }
            if ((children = source.list()) != null) {
                for (String aChildren : children) {
                    int dot = aChildren.lastIndexOf(46);
                    String base = dot == -1 ? aChildren : aChildren.substring(0, dot);
                    String extension = dot == -1 ? "" : aChildren.substring(dot);
                    String newfilename = base.replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~").replace(".", "%25") + extension;
                    Files.copyDirectory(new File(source, aChildren), new File(target, newfilename));
                }
            }
        } else {
            Files.copy(source, target);
        }
    }
}

