/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.docx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import org.pageseeder.docx.DOCXException;
import org.pageseeder.docx.util.Files;
import org.pageseeder.docx.util.XSLT;
import org.pageseeder.docx.util.ZipUtils;

public final class DOCXProcessor {
    public static String MEDIA_PREFIX = "kwo5nu83zotp2-";
    private final Builder _builder;
    private final Writer _log;

    private DOCXProcessor(Builder builder) {
        this(builder, new StringWriter());
    }

    private DOCXProcessor(Builder builder, Writer log) {
        if (builder.source() == null) {
            throw new NullPointerException("source is null");
        }
        if (builder.destination() == null) {
            throw new NullPointerException("destination is null");
        }
        this._builder = builder;
        this._log = log;
    }

    public String getLog() {
        if (this._log != null) {
            try {
                this._log.flush();
                this._log.close();
            }
            catch (IOException e) {
                return "";
            }
            return this._log.toString();
        }
        return "";
    }

    public void process() throws IOException {
        String name = this._builder.source().getName();
        if (name.endsWith(".psml")) {
            name = name.substring(0, name.length() - 5);
        }
        this.log("Extracting DOTX: " + this._builder.dotx().getName());
        File dotx = new File(this._builder.working(), "dotx");
        dotx.mkdirs();
        ZipUtils.unzip(this._builder.dotx(), dotx);
        this.log("Checking DOTX");
        File contentTypes = new File(dotx, "[Content_Types].xml");
        File relationships = new File(dotx, "_rels/.rels");
        File numbering = new File(dotx, "word/numbering.xml");
        if (!contentTypes.exists()) {
            throw new DOCXException("Not a valid DOTX: unable to find [Content_Types].xml");
        }
        if (!relationships.exists()) {
            throw new DOCXException("Not a valid DOTX: unable to find _rels/.rels");
        }
        if (!numbering.exists()) {
            throw new DOCXException("Not a valid DOTX: unable to find word/numbering.xml");
        }
        File prepacked = new File(this._builder.working(), "prepacked");
        prepacked.mkdirs();
        ZipUtils.unzip(this._builder.dotx(), prepacked);
        File document = new File(prepacked, "word/document.xml");
        Files.ensureDirectoryExists(document.getParentFile());
        File mediaFolder = new File(prepacked, "word/media");
        String mediaPrefix = "";
        if (this._builder.media() != null) {
            this.log("Copy media files");
            if (!mediaFolder.exists()) {
                mediaFolder.mkdirs();
            }
            mediaPrefix = MEDIA_PREFIX;
            Files.renameFiles(mediaFolder, mediaPrefix);
            Files.copyDirectory(this._builder.media(), mediaFolder);
        }
        this.log("Unnest");
        Templates unnest = XSLT.getTemplatesFromResource("org/pageseeder/docx/xslt/export-unnest.xsl");
        File sourceDocument = this._builder.source();
        File newSourceDocument = new File(this._builder.working(), "unnested/document-unnested.psml");
        newSourceDocument.getParentFile().mkdir();
        Map<String, String> noParameters = Collections.emptyMap();
        XSLT.transform(sourceDocument, newSourceDocument, unnest, noParameters, null);
        this.log("Process with XSLT");
        Templates templates = XSLT.getTemplatesFromResource("org/pageseeder/docx/xslt/export.xsl");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_outputfolder", prepacked.toURI().toString());
        parameters.put("_dotxfolder", dotx.toURI().toString());
        parameters.put("_docxfilename", this._builder.destination().getName());
        parameters.put("_mediaprefix", mediaPrefix);
        if (this._builder.config() != null) {
            parameters.put("_configfileurl", this._builder.config().toURI().toString());
        }
        parameters.putAll(this._builder.params());
        XSLT.transform(newSourceDocument, document, templates, parameters, null);
        if (parameters.containsKey("expanded") && ((String)parameters.get("expanded")).equals("true")) {
            this.log("Moving");
            if (!prepacked.renameTo(this._builder.destination())) {
                throw new DOCXException("Unable to move expanded DOCX");
            }
        } else if (parameters.containsKey("generate-processed-psml") && ((String)parameters.get("generate-processed-psml")).equals("true")) {
            this.log("Debug Mode");
            File newDestinationDocument = new File(this._builder.destination().getParentFile() + "/document.xml");
            try {
                Files.copy(document, newDestinationDocument);
            }
            catch (IOException ex) {
                throw new DOCXException(ex);
            }
            this._builder.destination().getParentFile().mkdirs();
            ZipUtils.zip(prepacked, this._builder.destination());
        } else {
            this.log("Zipping");
            this._builder.destination().getParentFile().mkdirs();
            ZipUtils.zip(prepacked, this._builder.destination());
        }
    }

    private void log(String log) throws IOException {
        this._log.append(log).append("\n");
    }

    public static class Builder {
        private File source;
        private File destination;
        private File working;
        private File dotx;
        private File config;
        private File media;
        private Map<String, String> params;
        private Writer log;

        private File source() {
            return this.source;
        }

        private File destination() {
            if (this.destination == null) {
                this.destination = new File(this.source.getParentFile(), "output.docx");
            }
            return this.destination;
        }

        private File working() {
            if (this.working == null) {
                String tmp = "docx-" + System.currentTimeMillis();
                this.working = new File(System.getProperty("java.io.tmpdir"), tmp);
            }
            if (!this.working.exists()) {
                this.working.mkdirs();
            }
            return this.working;
        }

        private File dotx() {
            if (this.dotx == null) {
                this.dotx = Builder.getBuiltinWordTemplate(this.working());
            }
            if (this.dotx != null && this.dotx.exists()) {
                return this.dotx;
            }
            return null;
        }

        private File config() {
            if (this.config != null && this.config.exists()) {
                return this.config;
            }
            return null;
        }

        private File media() {
            if (this.media != null && this.media.exists() && this.media.isDirectory()) {
                return this.media;
            }
            return null;
        }

        private Map<String, String> params() {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            return this.params;
        }

        public Builder source(File source) {
            this.source = source;
            return this;
        }

        public Builder destination(File destination) {
            this.destination = destination;
            return this;
        }

        public Builder working(File working) {
            this.working = working;
            return this;
        }

        public Builder dotx(File dotx) {
            this.dotx = dotx;
            return this;
        }

        public Builder config(File config) {
            this.config = config;
            return this;
        }

        public Builder media(File media) {
            this.media = media;
            return this;
        }

        public Builder params(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public Builder log(Writer log) {
            this.log = log;
            return this;
        }

        public DOCXProcessor build() {
            if (this.log != null) {
                return new DOCXProcessor(this, this.log);
            }
            return new DOCXProcessor(this);
        }

        private static File getBuiltinWordTemplate(File working) {
            File tmp = new File(working, "default.dotx");
            try {
                ClassLoader loader = DOCXProcessor.class.getClassLoader();
                try (InputStream in = loader.getResourceAsStream("org/pageseeder/docx/resource/default.dotx");
                     FileOutputStream out = new FileOutputStream(tmp);){
                    int n;
                    byte[] buffer = new byte[1024];
                    while ((n = in.read(buffer)) != -1) {
                        out.write(buffer, 0, n);
                    }
                }
            }
            catch (IOException ex) {
                throw new DOCXException("Unable to extract default word template", ex);
            }
            return tmp;
        }
    }
}

