/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron.svrl;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.pageseeder.schematron.svrl.ActivePattern;
import org.pageseeder.schematron.svrl.AssertOrReport;
import org.pageseeder.schematron.svrl.FiredRule;
import org.pageseeder.schematron.svrl.HumanText;
import org.pageseeder.schematron.svrl.Namespace;
import org.pageseeder.schematron.xml.XMLStreamable;

public final class SchematronOutput
implements XMLStreamable {
    private String title;
    private String phase;
    private String schemaVersion;
    private boolean isCompact;
    private final List<Namespace> nsDeclarations = new ArrayList<Namespace>();
    private final List<Namespace> nsPrefixInAttributeValues = new ArrayList<Namespace>();
    private final List<HumanText> texts = new ArrayList<HumanText>();
    private final List<ActivePattern> activePatterns = new ArrayList<ActivePattern>();

    public String getTitle() {
        return this.title;
    }

    public String getPhase() {
        return this.phase;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public List<HumanText> getTexts() {
        return this.texts;
    }

    public List<ActivePattern> getActivePatterns() {
        return this.activePatterns;
    }

    public List<AssertOrReport> getAllAssertsOrReports() {
        ArrayList<AssertOrReport> assertOrReports = new ArrayList<AssertOrReport>();
        for (ActivePattern activePattern : this.activePatterns) {
            for (FiredRule firedRule : activePattern.getFiredRules()) {
                for (AssertOrReport assertOrReport : firedRule.getAssertsAndReports()) {
                    assertOrReports.add(assertOrReport);
                }
            }
        }
        return assertOrReports;
    }

    public List<AssertOrReport> getFailedAsserts() {
        ArrayList<AssertOrReport> failedAsserts = new ArrayList<AssertOrReport>();
        for (ActivePattern activePattern : this.activePatterns) {
            for (FiredRule firedRule : activePattern.getFiredRules()) {
                for (AssertOrReport assertOrReport : firedRule.getAssertsAndReports()) {
                    if (!assertOrReport.isFailedAssert()) continue;
                    failedAsserts.add(assertOrReport);
                }
            }
        }
        return failedAsserts;
    }

    public List<AssertOrReport> getSuccessfulReports() {
        ArrayList<AssertOrReport> successfulReports = new ArrayList<AssertOrReport>();
        for (ActivePattern activePattern : this.activePatterns) {
            for (FiredRule firedRule : activePattern.getFiredRules()) {
                for (AssertOrReport assertOrReport : firedRule.getAssertsAndReports()) {
                    if (assertOrReport.isFailedAssert()) continue;
                    successfulReports.add(assertOrReport);
                }
            }
        }
        return successfulReports;
    }

    void setTitle(String title) {
        this.title = title;
    }

    public void setCompact(boolean compact) {
        this.isCompact = compact;
    }

    void setPhase(String phase) {
        this.phase = phase;
    }

    void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    void addText(HumanText text) {
        this.texts.add(text);
    }

    void addNsDeclaration(Namespace namespace) {
        this.nsDeclarations.add(namespace);
    }

    void addNsPrefixInAttributeValues(Namespace namespace) {
        this.nsPrefixInAttributeValues.add(namespace);
    }

    void addActivePattern(ActivePattern activePattern) {
        this.activePatterns.add(activePattern);
    }

    @Override
    public void toXMLStream(XMLStreamWriter xml) throws XMLStreamException {
        xml.writeStartElement("svrl", "schematron-output", "http://purl.oclc.org/dsdl/svrl");
        for (Namespace ns : this.nsDeclarations) {
            xml.writeNamespace(ns.getPrefix(), ns.getUri());
        }
        if (this.title != null) {
            xml.writeAttribute("title", this.title);
        }
        if (this.phase != null) {
            xml.writeAttribute("phase", this.phase);
        }
        if (this.schemaVersion != null) {
            xml.writeAttribute("schemaVersion", this.schemaVersion);
        }
        for (HumanText text : this.texts) {
            text.toXMLStream(xml);
        }
        for (Namespace namespace : this.nsPrefixInAttributeValues) {
            xml.writeEmptyElement("svrl", "ns-prefix-in-attribute-values", "http://purl.oclc.org/dsdl/svrl");
            xml.writeAttribute("prefix", namespace.getPrefix());
            xml.writeAttribute("uri", namespace.getUri());
        }
        if (this.isCompact) {
            for (ActivePattern activePattern : this.activePatterns) {
                for (FiredRule rule : activePattern.getFiredRules()) {
                    for (AssertOrReport assertOrReport : rule.getAssertsAndReports()) {
                        assertOrReport.toXMLStream(xml);
                    }
                }
            }
        } else {
            for (ActivePattern activePattern : this.activePatterns) {
                activePattern.toXMLStream(xml);
            }
        }
        xml.writeEndElement();
    }

    public String toXML() {
        StringWriter xml = new StringWriter();
        this.toXML(xml);
        return xml.toString();
    }

    public void toXML(Writer xml) {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = factory.createXMLStreamWriter(xml);
            writer.setPrefix("svrl", "http://purl.oclc.org/dsdl/svrl");
            this.toXMLStream(writer);
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

