/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.schematron.svrl;

import java.util.Objects;
import javax.xml.namespace.QName;

public final class Namespace {
    private final String prefix;
    private final String uri;

    public Namespace(String prefix, String uri) {
        this.prefix = Objects.toString(prefix, "");
        this.uri = Objects.toString(uri, "");
    }

    Namespace(QName name) {
        this(name.getPrefix(), name.getNamespaceURI());
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Namespace namespace = (Namespace)o;
        return this.getPrefix().equals(namespace.getPrefix()) && this.getUri().equals(namespace.getUri());
    }

    public int hashCode() {
        return Objects.hash(this.getPrefix(), this.getUri());
    }

    public String toString() {
        return "Namespace{prefix='" + this.prefix + '\'' + ", uri='" + this.uri + '\'' + '}';
    }
}

