/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.layout;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jeuclid.layout.GraphicsObject;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;

public class LayoutInfoImpl
implements LayoutInfo {
    private LayoutStage layoutStage = LayoutStage.NONE;
    private float ascentHeightS1;
    private float ascentHeightS2;
    private float descentHeightS1;
    private float descentHeightS2;
    private float horizontalS1;
    private float horizontalS2;
    private float widthS1;
    private float widthS2;
    private float posXS1;
    private float posXS2;
    private float posYS1;
    private float posYS2;
    private float stretchAscent = -1.0f;
    private float stretchDescent = -1.0f;
    private float stretchWidth = -1.0f;
    private final List<GraphicsObject> graphicObjects = new ArrayList<GraphicsObject>();

    @Override
    public LayoutStage getLayoutStage() {
        return this.layoutStage;
    }

    @Override
    public void setLayoutStage(LayoutStage layoutStage) {
        this.layoutStage = layoutStage;
    }

    @Override
    public float getAscentHeight(LayoutStage layoutStage) {
        if (LayoutStage.STAGE1.equals((Object)layoutStage)) {
            return this.ascentHeightS1;
        }
        return this.ascentHeightS2;
    }

    @Override
    public float getDescentHeight(LayoutStage layoutStage) {
        if (LayoutStage.STAGE1.equals((Object)layoutStage)) {
            return this.descentHeightS1;
        }
        return this.descentHeightS2;
    }

    @Override
    public float getHorizontalCenterOffset(LayoutStage layoutStage) {
        if (LayoutStage.STAGE1.equals((Object)layoutStage)) {
            return this.horizontalS1;
        }
        return this.horizontalS2;
    }

    @Override
    public float getPosX(LayoutStage layoutStage) {
        if (LayoutStage.STAGE1.equals((Object)layoutStage)) {
            return this.posXS1;
        }
        return this.posXS2;
    }

    @Override
    public float getPosY(LayoutStage layoutStage) {
        if (LayoutStage.STAGE1.equals((Object)layoutStage)) {
            return this.posYS1;
        }
        return this.posYS2;
    }

    @Override
    public float getWidth(LayoutStage layoutStage) {
        if (LayoutStage.STAGE1.equals((Object)layoutStage)) {
            return this.widthS1;
        }
        return this.widthS2;
    }

    @Override
    public void moveTo(float f, float f2, LayoutStage layoutStage) {
        this.posXS2 = f;
        this.posYS2 = f2;
        if (LayoutStage.STAGE1.equals((Object)layoutStage)) {
            this.posXS1 = f;
            this.posYS1 = f2;
        }
    }

    @Override
    public void setAscentHeight(float f, LayoutStage layoutStage) {
        this.ascentHeightS2 = f;
        if (LayoutStage.STAGE1.equals((Object)layoutStage)) {
            this.ascentHeightS1 = f;
        }
    }

    @Override
    public void setDescentHeight(float f, LayoutStage layoutStage) {
        this.descentHeightS2 = f;
        if (LayoutStage.STAGE1.equals((Object)layoutStage)) {
            this.descentHeightS1 = f;
        }
    }

    @Override
    public void setHorizontalCenterOffset(float f, LayoutStage layoutStage) {
        this.horizontalS2 = f;
        if (LayoutStage.STAGE1.equals((Object)layoutStage)) {
            this.horizontalS1 = f;
        }
    }

    @Override
    public void setWidth(float f, LayoutStage layoutStage) {
        this.widthS2 = f;
        if (LayoutStage.STAGE1.equals((Object)layoutStage)) {
            this.widthS1 = f;
        }
    }

    @Override
    public void setGraphicsObject(GraphicsObject graphicsObject) {
        this.graphicObjects.clear();
        this.graphicObjects.add(graphicsObject);
    }

    @Override
    public List<GraphicsObject> getGraphicObjects() {
        return this.graphicObjects;
    }

    @Override
    public float getStretchWidth() {
        return this.stretchWidth;
    }

    @Override
    public void setStretchWidth(float f) {
        this.stretchWidth = f;
    }

    @Override
    public float getStretchAscent() {
        if (this.stretchAscent < 0.0f) {
            return this.ascentHeightS1;
        }
        return this.stretchAscent;
    }

    @Override
    public float getStretchDescent() {
        if (this.stretchDescent < 0.0f) {
            return this.descentHeightS1;
        }
        return this.stretchDescent;
    }

    @Override
    public void setStretchAscent(float f) {
        this.stretchAscent = f;
    }

    @Override
    public void setStretchDescent(float f) {
        this.stretchDescent = f;
    }

    @Override
    public void shiftVertically(float f, LayoutStage layoutStage) {
        this.posYS2 += f;
        if (LayoutStage.STAGE1.equals((Object)layoutStage)) {
            this.posYS1 += f;
        }
    }
}

