/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.local;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexManager;
import org.pageseeder.flint.Requester;
import org.pageseeder.flint.indexing.IndexBatch;
import org.pageseeder.flint.indexing.IndexJob;
import org.pageseeder.flint.local.LocalFileContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalIndexer
implements FileVisitor<Path> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalIndexer.class);
    private final IndexManager _manager;
    private final Index _index;
    private long _indexModifiedDate = -1L;
    private Map<String, Long> indexedFiles = null;
    private FileFilter fileFilter = null;
    private FileFilter directoryFilter = null;
    private IndexBatch batch = null;
    private boolean useIndexDate = true;
    private final Requester _requester = new Requester("Local Indexer");
    private final Map<String, Action> resultFiles = new ConcurrentHashMap<String, Action>();
    private IndexJob.Priority priority = IndexJob.Priority.LOW;

    public LocalIndexer(IndexManager manager, Index index) {
        this._manager = manager;
        this._index = index;
    }

    public void setHighPriority() {
        this.priority = IndexJob.Priority.HIGH;
    }

    public void setLowPriority() {
        this.priority = IndexJob.Priority.LOW;
    }

    public void setFileFilter(FileFilter filter) {
        this.fileFilter = filter;
    }

    public void setDirectoryFilter(FileFilter directoryFilter) {
        this.directoryFilter = directoryFilter;
    }

    public void setUseIndexDate(boolean useIndxDate) {
        this.useIndexDate = useIndxDate;
    }

    public int indexFolder(File root, Map<String, Long> indexed) {
        if (root == null) {
            throw new NullPointerException("root");
        }
        if (!root.exists()) {
            return 0;
        }
        if (root.isDirectory()) {
            this._indexModifiedDate = indexed == null || indexed.isEmpty() ? -1L : this._index.getIndexIO().getLastTimeUsed();
            this.batch = new IndexBatch(this._index.getIndexID());
            this.indexedFiles = indexed;
            try {
                Files.walkFileTree(root.toPath(), Collections.singleton(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, this);
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to collect files to index from folder {}", (Object)root, (Object)ex);
            }
            if (this.indexedFiles != null) {
                for (String path : this.indexedFiles.keySet()) {
                    this.resultFiles.put(path, Action.DELETE);
                    this.batch.increaseTotal();
                    this._manager.indexBatch(this.batch, path, LocalFileContentType.SINGLETON, this._index, this._requester, this.priority, null);
                }
            }
            this.batch.setComputed();
            return this.resultFiles.size();
        }
        LOGGER.warn("Trying to index file {} as a folder", (Object)root.getAbsolutePath());
        return 0;
    }

    public IndexBatch getBatch() {
        return this.batch;
    }

    public Map<String, Action> getIndexedFiles() {
        return this.resultFiles;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
        Long indexModified;
        File file = path.toFile();
        String aspath = file.getAbsolutePath();
        Long l = indexModified = this.indexedFiles == null ? null : this.indexedFiles.remove(aspath);
        if (!this.useIndexDate || this._indexModifiedDate == -1L || attrs.lastModifiedTime().toMillis() > this._indexModifiedDate) {
            if (this.fileFilter != null && !this.fileFilter.accept(file)) {
                return FileVisitResult.CONTINUE;
            }
            if (indexModified == null) {
                this.resultFiles.put(aspath, Action.INSERT);
            } else {
                this.resultFiles.put(aspath, Action.UPDATE);
            }
            this.batch.increaseTotal();
            this._manager.indexBatch(this.batch, aspath, LocalFileContentType.SINGLETON, this._index, this._requester, IndexJob.Priority.HIGH, null);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        File file = dir.toFile();
        if (this.directoryFilter != null && !this.directoryFilter.accept(file)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        LOGGER.error("Failed to collect document {}", (Object)file, (Object)exc);
        return FileVisitResult.CONTINUE;
    }

    public static enum Action {
        INSERT,
        UPDATE,
        DELETE,
        IGNORE;

    }
}

