/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.local;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentType;
import org.pageseeder.flint.content.DeleteRule;
import org.pageseeder.flint.local.LocalFileContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileContent
implements Content {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFileContent.class);
    private final File _f;
    private final DeleteRule _deleteRule;

    public LocalFileContent(File f, DeleteRule rule) {
        this._f = f;
        this._deleteRule = rule;
    }

    @Override
    public ContentType getContentType() {
        return LocalFileContentType.SINGLETON;
    }

    @Override
    public String getContentID() {
        return this._f.getAbsolutePath();
    }

    @Override
    public String getMediaType() {
        String name = this._f.getName();
        int lastDot = name.lastIndexOf(46);
        return lastDot == -1 ? "" : name.substring(lastDot + 1);
    }

    @Override
    public DeleteRule getDeleteRule() {
        return this._deleteRule;
    }

    @Override
    public File getFile() {
        return this._f;
    }

    @Override
    public final InputStream getSource() {
        if (!this._f.exists()) {
            return null;
        }
        try {
            return new BufferedInputStream(new FileInputStream(this._f));
        }
        catch (IOException ex) {
            LOGGER.warn("Unable to get input source for {}", (Object)this._f, (Object)ex);
            return null;
        }
    }

    @Override
    public final boolean isDeleted() {
        return !this._f.exists();
    }

    public File file() {
        return this._f;
    }

    public static String getContentID(File f) {
        return f.getAbsolutePath();
    }
}

