/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.ixml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class FlintEntityResolver
implements EntityResolver {
    public static final String PUBLIC_ID_PREFIX_LEGACY = "-//Weborganic//DTD::Flint Index Documents ";
    public static final String PUBLIC_ID_PREFIX = "-//Flint//DTD::Index Documents ";
    private static final String PUBLIC_ID_SUFFIX = "//EN";
    private static final FlintEntityResolver SINGLETON = new FlintEntityResolver();

    private FlintEntityResolver() {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        String dtd = FlintEntityResolver.toFileName(publicId);
        if (dtd != null) {
            InputStream inputStream = FlintEntityResolver.class.getResourceAsStream("/library/" + dtd);
            if (inputStream == null) {
                inputStream = this.toInputStream(systemId);
            }
            if (inputStream == null) {
                return null;
            }
            return new InputSource(inputStream);
        }
        return null;
    }

    private static String toFileName(String publicId) {
        if (publicId == null) {
            return null;
        }
        String version = null;
        if (publicId.startsWith(PUBLIC_ID_PREFIX)) {
            int length;
            int n = length = publicId.endsWith(PUBLIC_ID_SUFFIX) ? publicId.length() - PUBLIC_ID_SUFFIX.length() : publicId.length();
            if (length <= PUBLIC_ID_PREFIX.length()) {
                return null;
            }
            version = publicId.substring(PUBLIC_ID_PREFIX.length(), length);
        } else if (publicId.startsWith(PUBLIC_ID_PREFIX_LEGACY)) {
            int length;
            int n = length = publicId.endsWith(PUBLIC_ID_PREFIX_LEGACY) ? publicId.length() - PUBLIC_ID_PREFIX_LEGACY.length() : publicId.length();
            if (length <= PUBLIC_ID_PREFIX_LEGACY.length()) {
                return null;
            }
            version = publicId.substring(PUBLIC_ID_PREFIX_LEGACY.length(), length);
        }
        if (version == null) {
            return null;
        }
        return "index-documents-" + version + ".dtd";
    }

    public static FlintEntityResolver getInstance() {
        return SINGLETON;
    }

    private InputStream toInputStream(String systemId) throws SAXException {
        if (systemId.startsWith("http")) {
            try {
                URL url = new URL(systemId);
                return url.openStream();
            }
            catch (IOException ex) {
                throw new SAXException("Unable to resolve entity.", ex);
            }
        }
        try {
            return new FileInputStream(systemId);
        }
        catch (FileNotFoundException ex) {
            throw new SAXException("Unable to resolve entity.", ex);
        }
    }
}

