/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.indexing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.Requester;
import org.pageseeder.flint.indexing.IndexBatch;
import org.pageseeder.flint.indexing.IndexJob;

public final class IndexJobQueue {
    private final PriorityBlockingQueue<IndexJob> _queue = new PriorityBlockingQueue();
    private final PriorityBlockingQueue<IndexJob> _singleThreadQueue;

    public IndexJobQueue(boolean withSingleThreadQueue) {
        this._singleThreadQueue = withSingleThreadQueue ? new PriorityBlockingQueue() : null;
    }

    public void addSingleThreadJob(IndexJob job) {
        this.addJob(job, true);
    }

    public void addMultiThreadJob(IndexJob job) {
        this.addJob(job, false);
    }

    public List<IndexJob> getJobsForRequester(Requester requester) {
        if (requester == null) {
            return this.getAllJobs();
        }
        ArrayList<IndexJob> jobs = new ArrayList<IndexJob>();
        for (IndexJob job : this._queue) {
            if (!job.isForRequester(requester)) continue;
            jobs.add(job);
        }
        if (this._singleThreadQueue != null) {
            for (IndexJob job : this._singleThreadQueue) {
                if (!job.isForRequester(requester)) continue;
                jobs.add(job);
            }
        }
        return jobs;
    }

    public int countJobsForRequester(Requester requester) {
        if (requester == null) {
            return this._queue.size();
        }
        int count = 0;
        for (IndexJob job : this._queue) {
            if (!job.isForRequester(requester)) continue;
            ++count;
        }
        if (this._singleThreadQueue != null) {
            for (IndexJob job : this._singleThreadQueue) {
                if (!job.isForRequester(requester)) continue;
                ++count;
            }
        }
        return count;
    }

    public void clearJobsForIndex(Index index) {
        if (index == null) {
            return;
        }
        ArrayList<IndexJob> jobs = new ArrayList<IndexJob>();
        for (IndexJob job : this._queue) {
            if (!job.isForIndex(index)) continue;
            jobs.add(job);
        }
        this._queue.removeAll(jobs);
        if (this._singleThreadQueue != null) {
            jobs.clear();
            for (IndexJob job : this._singleThreadQueue) {
                if (!job.isForIndex(index)) continue;
                jobs.add(job);
            }
            this._singleThreadQueue.removeAll(jobs);
        }
    }

    public List<IndexJob> getJobsForIndex(Index index) {
        if (index == null) {
            return this.getAllJobs();
        }
        ArrayList<IndexJob> jobs = new ArrayList<IndexJob>();
        for (IndexJob job : this._queue) {
            if (!job.isForIndex(index)) continue;
            jobs.add(job);
        }
        if (this._singleThreadQueue != null) {
            for (IndexJob job : this._singleThreadQueue) {
                if (!job.isForIndex(index)) continue;
                jobs.add(job);
            }
        }
        return jobs;
    }

    public boolean hasJobsForIndex(Index index) {
        if (index != null) {
            for (IndexJob job : this._queue) {
                if (!job.isForIndex(index)) continue;
                return true;
            }
            if (this._singleThreadQueue != null) {
                for (IndexJob job : this._singleThreadQueue) {
                    if (!job.isForIndex(index)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int countJobsForIndex(Index index) {
        if (index == null) {
            return this._queue.size();
        }
        int count = 0;
        for (IndexJob job : this._queue) {
            if (!job.isForIndex(index)) continue;
            ++count;
        }
        if (this._singleThreadQueue != null) {
            for (IndexJob job : this._singleThreadQueue) {
                if (!job.isForIndex(index)) continue;
                ++count;
            }
        }
        return count;
    }

    public List<IndexJob> getAllJobs() {
        ArrayList<IndexJob> list = new ArrayList<IndexJob>(this._queue);
        if (this._singleThreadQueue != null) {
            list.addAll(this._singleThreadQueue);
        }
        return list;
    }

    public IndexJob nextMultiThreadJob() throws InterruptedException {
        return this._queue.take();
    }

    public IndexJob nextSingleThreadJob() throws InterruptedException {
        return this._singleThreadQueue != null ? this._singleThreadQueue.take() : null;
    }

    public boolean isMultiThreadsEmpty() {
        return this._queue.isEmpty();
    }

    public boolean isSingleThreadEmpty() {
        return this._singleThreadQueue == null || this._singleThreadQueue.isEmpty();
    }

    public void clear() {
        this._queue.clear();
        if (this._singleThreadQueue != null) {
            this._singleThreadQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJob(IndexJob job, boolean singleThread) {
        boolean existingHasPriority;
        IndexJob existing;
        PriorityBlockingQueue<IndexJob> priorityBlockingQueue = this._queue;
        synchronized (priorityBlockingQueue) {
            existing = this._queue.stream().filter(ajob -> ajob.isSimilar(job)).findFirst().orElse(null);
        }
        boolean foundInSingleQueue = false;
        if (existing == null && this._singleThreadQueue != null) {
            PriorityBlockingQueue<IndexJob> priorityBlockingQueue2 = this._singleThreadQueue;
            synchronized (priorityBlockingQueue2) {
                existing = this._singleThreadQueue.stream().filter(ajob -> ajob.isSimilar(job)).findFirst().orElse(null);
                foundInSingleQueue = existing != null;
            }
        }
        boolean higherPriority = existing != null && existing.getPriority() == IndexJob.Priority.LOW && job.getPriority() == IndexJob.Priority.HIGH;
        boolean force = job.isBatch() && job.getBatch().hasClearJob();
        boolean bl = existingHasPriority = existing != null && existing.isBatch() && existing.getBatch().hasClearJob();
        if (!existingHasPriority && (existing == null || force || higherPriority)) {
            if (singleThread && this._singleThreadQueue != null) {
                PriorityBlockingQueue<IndexJob> priorityBlockingQueue3 = this._singleThreadQueue;
                synchronized (priorityBlockingQueue3) {
                    if (existing != null && !force) {
                        this.removeExistingJob(job, existing, foundInSingleQueue);
                    }
                    this._singleThreadQueue.put(job);
                }
            } else {
                PriorityBlockingQueue<IndexJob> priorityBlockingQueue4 = this._queue;
                synchronized (priorityBlockingQueue4) {
                    if (existing != null && !force) {
                        this.removeExistingJob(job, existing, foundInSingleQueue);
                    }
                    this._queue.put(job);
                }
            }
        } else {
            IndexBatch batch = job.getBatch();
            if (batch != null && batch.getCurrentCount() != batch.getTotalDocuments() - 1) {
                batch.remove(1);
            }
        }
    }

    private void removeExistingJob(IndexJob job, IndexJob existing, boolean foundInSingleQueue) {
        IndexBatch batch = existing.getBatch();
        if (batch != null && batch.getCurrentCount() != batch.getTotalDocuments() - 1) {
            batch.remove(1);
        }
        if (foundInSingleQueue) {
            this._singleThreadQueue.remove(existing);
        } else {
            this._queue.remove(existing);
        }
    }
}

