/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth.resource;

import com.pageseeder.base.oauth.core.OAuthErrorType;
import com.pageseeder.base.oauth.core.OAuthException;
import com.pageseeder.base.oauth.core.OAuthRequest;
import com.pageseeder.base.oauth.core.OAuthRequestValidator;
import com.pageseeder.common.oauth.HTTP;
import com.pageseeder.common.util.Strings;
import javax.servlet.http.HttpServletRequest;

public final class ResourceRequest
extends OAuthRequest {
    private final String accessToken;

    private ResourceRequest(HttpServletRequest req, String accessToken) {
        super(req);
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public static ResourceRequest newInstance(HttpServletRequest req) throws OAuthException {
        OAuthRequestValidator validator = new OAuthRequestValidator((OAuthRequestValidator.Constraint)new HasBearerToken());
        String header = req.getHeader("Authorization");
        String bearer = HTTP.getBearerToken((String)header);
        assert (bearer != null);
        ResourceRequest oauth = new ResourceRequest(req, bearer);
        validator.validate((OAuthRequest)oauth);
        return oauth;
    }

    private static class HasBearerToken
    implements OAuthRequestValidator.Constraint {
        private HasBearerToken() {
        }

        public void validate(OAuthRequest req) throws OAuthException {
            String header = req.getAuthorizationHeader();
            if (Strings.isEmpty((String)header)) {
                throw OAuthException.error((OAuthErrorType)OAuthErrorType.invalid_token, (String)"Missing authorization header.");
            }
            String method = HTTP.getAuthScheme((String)header);
            if (!"Bearer".equals(method)) {
                throw OAuthException.error((OAuthErrorType)OAuthErrorType.invalid_token, (String)"Incorrect authorization method.");
            }
            String token = HTTP.getBearerToken((String)header);
            if (Strings.isEmpty((String)token)) {
                throw OAuthException.error((OAuthErrorType)OAuthErrorType.invalid_token, (String)"Missing or invalid token.");
            }
        }
    }
}

