/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth.resource;

import com.pageseeder.base.oauth.core.OAuthErrorResponse;
import com.pageseeder.base.oauth.core.OAuthErrorType;
import com.pageseeder.base.oauth.core.OAuthException;
import com.pageseeder.base.oauth.model.AccessToken;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.common.oauth.HTTP;
import com.pageseeder.oauth.resource.ResourceRequest;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceFilter.class);
    public static final String DEFAULT_REALM = "OAuth";
    private String realm = "OAuth";

    public void init(FilterConfig config) {
        String customRealm = config.getInitParameter("oauth-resource-realm");
        if (customRealm != null) {
            this.realm = customRealm;
        }
    }

    public void destroy() {
        this.realm = DEFAULT_REALM;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.doHttpFilter((HttpServletRequest)req, (HttpServletResponse)res, chain);
    }

    public String getRealm() {
        return this.realm;
    }

    public void doHttpFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String authorization = req.getHeader(HTTP.Header.Authorization.toString());
        if (authorization != null && authorization.startsWith("Bearer")) {
            this.filterBearer(req, res, chain);
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    void filterBearer(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            this.unsafeFilterBearer(req, res, chain);
        }
        catch (RuntimeException ex) {
            LOGGER.error("OAuth2 system error: {}", (Object)ex.getMessage(), (Object)ex);
            OAuthException error = OAuthException.error((OAuthErrorType)OAuthErrorType.server_error);
            this.handleError(req, res, error);
        }
    }

    private void unsafeFilterBearer(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        try {
            ResourceRequest oauth = ResourceRequest.newInstance(req);
            String code = oauth.getAccessToken();
            AccessTokenManager manager = AccessTokenManager.singleton();
            AccessToken token = manager.get(code);
            if (token == null || token.hasExpired()) {
                throw OAuthException.error((OAuthErrorType)OAuthErrorType.invalid_token).responseStatus(401);
            }
            long memberId = token.getMemberId();
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
        catch (OAuthException ex) {
            this.handleError(req, res, ex);
        }
    }

    private void handleError(HttpServletRequest req, HttpServletResponse res, OAuthException ex) {
        OAuthErrorResponse response = new OAuthErrorResponse(ex.getResponseStatus()).error(ex).setRealm(this.realm);
        if (HTTP.expectsXML((HttpServletRequest)req)) {
            response.toXMLMessage(res);
        } else {
            response.toJSONMessage(res);
        }
    }
}

