/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth.openid;

import com.pageseeder.base.oauth.jwt.JWTClaim;
import com.pageseeder.base.oauth.jwt.JWTClaimSet;
import com.pageseeder.base.oauth.openid.ClaimsProvider;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.oauth.Scope;
import com.pageseeder.oauth.resource.ResourceFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class UserInfoServlet
extends HttpServlet {
    private final ResourceFilter protection = new ResourceFilter();

    public void init(ServletConfig config) {
        this.protection.init(new ServletConfigWrapper(config));
    }

    public void destroy() {
        this.protection.destroy();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) {
        this.process(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) {
        this.process(req, res);
    }

    private void process(HttpServletRequest req, HttpServletResponse res) {
        WebRequest wr = new WebRequest(req, res);
        ServletWrapper chain = new ServletWrapper(this);
        try {
            this.protection.doFilter((ServletRequest)req, (ServletResponse)res, chain);
        }
        catch (Exception ex) {
            wr.sendError(ex);
        }
    }

    private void fetchUserInfo(HttpServletRequest req, HttpServletResponse res) {
        WebRequest wr = new WebRequest(req, res);
        String subject = (String)req.getAttribute("oauth2.username");
        String scope = (String)req.getAttribute("oauth2.scope");
        if (subject == null || scope == null) {
            wr.sendError(503, "Missing scope or subject");
            return;
        }
        Long memberId = -1L;
        Set scopes = Scope.fromDelimitedString((String)scope);
        try (Database db = Database.open();){
            ClaimsProvider provider = new ClaimsProvider();
            JWTClaimSet claimset = provider.getClaims(db, memberId, scopes);
            claimset.setIssuer("https://self-issued.me");
            claimset.setSubject(subject);
            claimset.setAudience("oauth2.client");
            claimset.add(new JWTClaim(JWTClaim.Registered.exp, System.currentTimeMillis() / 1000L + 3600L));
            claimset.setIssuedAtToNow();
            res.setCharacterEncoding("utf-8");
            res.setContentType("application/json; charset=utf-8");
            PrintWriter writer = res.getWriter();
            writer.write(claimset.toJSON());
        }
        catch (IOException ex) {
            wr.sendError((Exception)ex);
        }
        catch (DatabaseException ex) {
            wr.sendError(502, "Unable to connect to database");
        }
    }

    private static class ServletConfigWrapper
    implements FilterConfig {
        private final ServletConfig config;

        public ServletConfigWrapper(ServletConfig config) {
            this.config = config;
        }

        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }

        public Enumeration<String> getInitParameterNames() {
            return this.config.getInitParameterNames();
        }

        public String getInitParameter(String name) {
            return this.config.getInitParameter(name);
        }

        public String getFilterName() {
            return this.config.getServletName();
        }
    }

    private static class ServletWrapper
    implements FilterChain {
        private final UserInfoServlet servlet;

        public ServletWrapper(UserInfoServlet servlet) {
            this.servlet = servlet;
        }

        public void doFilter(ServletRequest req, ServletResponse res) {
            this.servlet.fetchUserInfo((HttpServletRequest)req, (HttpServletResponse)res);
        }
    }
}

