/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth.authorizer;

import com.pageseeder.base.oauth.model.AccessToken;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.web.WebRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pageseeder.berlioz.json.Json;
import org.pageseeder.berlioz.json.JsonWriter;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;

public final class ValidationServlet
extends HttpServlet {
    private static final String XML_MEDIATYPE = "application/xml";
    private static final String JSON_MEDIATYPE = "application/json";
    private static final long serialVersionUID = 6922354577428372996L;

    protected void doPost(HttpServletRequest req, HttpServletResponse res) {
        try {
            this.validate(req, res);
        }
        catch (IOException | RuntimeException ex) {
            WebRequest wr = new WebRequest(req, res);
            wr.sendError(ex);
        }
    }

    private void validate(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String token = req.getParameter("access_token");
        AccessTokenManager tokens = AccessTokenManager.singleton();
        AccessToken verified = tokens.get(token);
        String accept = req.getHeader("Accept");
        boolean isJSON = !accept.contains(XML_MEDIATYPE);
        res.setContentType(isJSON ? JSON_MEDIATYPE : XML_MEDIATYPE);
        res.setHeader("Cache-Control", "no-store");
        PrintWriter pw = res.getWriter();
        if (verified != null) {
            res.setStatus(200);
            pw.print(isJSON ? ValidationServlet.toJSON(verified) : ValidationServlet.toXML(verified));
        } else {
            res.setStatus(400);
            pw.print(isJSON ? "{\"invalid-token\":true}" : "<invalid-token/>");
        }
        pw.flush();
        pw.close();
    }

    public static String toJSON(AccessToken token) {
        StringWriter w = new StringWriter();
        String username = Long.toString(token.getMemberId());
        try (JsonWriter json = Json.newWriter((Writer)w);){
            json.startObject();
            json.field("audience", token.getClientId());
            json.field("username", username);
            json.field("scope", token.scope());
            json.field("expires", token.expires().toEpochSecond());
            json.endObject();
        }
        return w.toString();
    }

    public static String toXML(AccessToken token) {
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        xml.openElement("verified-token");
        xml.attribute("audience", token.getClientId());
        xml.attribute("username", Long.toString(token.getMemberId()));
        xml.attribute("scope", token.scope());
        xml.attribute("expires", Long.toString(token.expires().toEpochSecond()));
        xml.closeElement();
        xml.flush();
        return xml.toString();
    }
}

