/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth.authorizer;

import com.pageseeder.base.oauth.core.OAuthParameter;
import com.pageseeder.base.oauth.core.OAuthResponse;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;

public final class AuthorizationResponse
extends OAuthResponse {
    public AuthorizationResponse(int status, @Nullable String state) {
        super(status);
        if (state != null) {
            this.setState(state);
        }
    }

    AuthorizationResponse setState(String state) {
        this.parameters.put(OAuthParameter.state, state);
        return this;
    }

    public AuthorizationResponse setCode(String code) {
        this.parameters.put(OAuthParameter.code, code);
        return this;
    }

    public AuthorizationResponse setAccessToken(String token) {
        this.parameters.put(OAuthParameter.access_token, token);
        return this;
    }

    public AuthorizationResponse setExpiresIn(long duration, TimeUnit unit) {
        String expiresIn = Long.toString(TimeUnit.SECONDS.convert(duration, unit));
        this.parameters.put(OAuthParameter.expires_in, expiresIn);
        return this;
    }

    public AuthorizationResponse location(String location) {
        this.location = location;
        return this;
    }
}

