/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageOAuthCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import java.io.IOException;
import java.util.List;

@Output(types={OutputType.JSON, OutputType.XML})
public final class ListRefreshTokens
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageOAuthCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        int pageSize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 1000L);
        Database db = req.getDatabase();
        List tokens = OAuthQuery.listRefreshTokens((Database)db, (int)page, (int)pageSize);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("refresh-tokens");
        out.field("manual-token-creation", GlobalSettings.getBoolean((String)"manualTokenCreation", (boolean)false));
        out.startCollection("refresh-tokens", OutputPrinter.CollectionOption.JSON_ONLY);
        for (PersistentToken token : tokens) {
            out.writePersistentToken(token);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

