/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewOAuthMemberCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.Client;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.oauth.util.MemberErrorID;
import com.pageseeder.oauth.util.Members;
import java.io.IOException;
import java.util.List;

@Output(types={OutputType.XML, OutputType.JSON})
public final class ListClientsForMember
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Member mem;
        try {
            mem = Members.getMember(req);
        }
        catch (DatabaseException ex) {
            return new NoCheck();
        }
        return new ViewOAuthMemberCheck(mem);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        Member mem = Members.getMember(req);
        if (mem == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
            return;
        }
        List clients = OAuthQuery.listClientsByMemberID((Database)db, (Long)mem.getId());
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("clients");
        out.startCollection("clients", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Client client : clients) {
            out.writeClient(client);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

