/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.oauth.model.AccessToken;
import com.pageseeder.base.oauth.model.AccessTokenManager;
import com.pageseeder.base.permission.ManageOAuthCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

@Output(types={OutputType.JSON, OutputType.XML})
public final class ListAccessTokens
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageOAuthCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        int pageSize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 1000L);
        int from = (page - 1) * pageSize;
        int to = page * pageSize;
        AccessTokenManager manager = AccessTokenManager.singleton();
        List tokens = manager.listTokens(from, to);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("access-tokens");
        out.field("total", (long)manager.getTotalTokens());
        OffsetDateTime lastPurged = manager.getLastPurged();
        if (lastPurged != null) {
            out.field("last-purged", lastPurged.format(AccessToken.ISO8601_DATETIME));
        }
        out.field("manual-token-creation", GlobalSettings.getBoolean((String)"manualTokenCreation", (boolean)false));
        out.startCollection("access-tokens", OutputPrinter.CollectionOption.JSON_ONLY);
        for (AccessToken token : tokens) {
            token.print((OutputPrinter)out, true);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

