/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.xml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.TextListToken;
import org.pageseeder.diffx.xml.Sequence;

public final class Sequences {
    private Sequences() {
    }

    public static boolean isWellFormed(Sequence sequence) {
        if (sequence == null) {
            return false;
        }
        ArrayDeque<XMLToken> open = new ArrayDeque<XMLToken>();
        for (int i = 0; i < sequence.size(); ++i) {
            XMLToken token = sequence.getToken(i);
            if (token.getType() == XMLTokenType.START_ELEMENT) {
                open.push(token);
                continue;
            }
            if (token.getType() != XMLTokenType.END_ELEMENT) continue;
            if (open.isEmpty()) {
                return false;
            }
            StartElementToken o = (StartElementToken)open.peek();
            String lastOpenElementName = o.getName();
            String closeElementName = token.getName();
            if (closeElementName.equals(lastOpenElementName)) continue;
            return false;
        }
        return open.isEmpty();
    }

    public static int getMaxDepth(Sequence sequence) {
        int max = 0;
        int depth = 0;
        for (int i = 0; i < sequence.size(); ++i) {
            if (sequence.getToken(i) instanceof StartElementToken) {
                ++depth;
            } else if (sequence.getToken(i) instanceof EndElementToken) {
                --depth;
            }
            if (depth <= max) continue;
            max = depth;
        }
        return max;
    }

    public static int getMaxElementContent(Sequence sequence) {
        int max = 0;
        int tmp = 0;
        for (int i = 0; i < sequence.size(); ++i) {
            XMLToken token = sequence.getToken(i);
            if (token instanceof StartElementToken) {
                tmp = 0;
                continue;
            }
            if (token instanceof EndElementToken) {
                if (tmp <= max) continue;
                max = tmp;
                continue;
            }
            ++tmp;
        }
        return max;
    }

    public static Sequence foldText(Sequence input) {
        ArrayList<TextToken> text = new ArrayList<TextToken>();
        Sequence output = new Sequence(input.getNamespaces());
        for (XMLToken token : input) {
            if (token instanceof TextToken) {
                text.add((TextToken)token);
                continue;
            }
            if (text.size() > 1) {
                output.addToken(new TextListToken(text));
                text.clear();
            } else if (text.size() == 1) {
                output.addToken((XMLToken)text.remove(0));
            }
            output.addToken(token);
        }
        return output;
    }
}

