/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.XMLStartElement;
import org.pageseeder.diffx.xml.Namespace;
import org.pageseeder.diffx.xml.Sequence;
import org.pageseeder.diffx.xml.SequenceProcessor;

public class WhitespaceStripper
implements SequenceProcessor {
    private final Set<StartElementToken> elementsToIgnore;

    public WhitespaceStripper() {
        this.elementsToIgnore = new HashSet<StartElementToken>();
    }

    public WhitespaceStripper(String ... names) {
        this.elementsToIgnore = this.toSet(names, Namespace.NO_NAMESPACE);
    }

    public void setElementsToIgnore(String ... names) {
        this.setElementsToIgnore(Namespace.NO_NAMESPACE, names);
    }

    public void setElementsToIgnore(Namespace ns, String ... names) {
        this.elementsToIgnore.clear();
        this.elementsToIgnore.addAll(this.toSet(names, ns));
    }

    @Override
    @NotNull
    public Sequence process(@NotNull Sequence sequence) {
        return new Sequence(this.strip(sequence.tokens()), sequence.getNamespaces());
    }

    @Override
    @NotNull
    public List<XMLToken> process(@NotNull List<XMLToken> tokens) {
        return this.strip(tokens);
    }

    @NotNull
    public Sequence strip(@NotNull Sequence sequence) {
        return new Sequence(this.strip(sequence.tokens()), sequence.getNamespaces());
    }

    public List<XMLToken> strip(List<XMLToken> tokens) {
        ArrayDeque<StartElementToken> context = new ArrayDeque<StartElementToken>();
        boolean ignorableContext = false;
        ArrayList<XMLToken> stripped = new ArrayList<XMLToken>(tokens.size());
        for (XMLToken token : tokens) {
            XMLTokenType type = token.getType();
            boolean include = true;
            if (type == XMLTokenType.START_ELEMENT) {
                context.push((StartElementToken)token);
                ignorableContext = this.elementsToIgnore.contains(context.peek());
            } else if (type == XMLTokenType.END_ELEMENT) {
                context.pop();
                ignorableContext = this.elementsToIgnore.contains(context.peek());
            } else if (type == XMLTokenType.TEXT && ignorableContext && token.isWhitespace()) {
                include = false;
            }
            if (!include) continue;
            stripped.add(token);
        }
        return stripped;
    }

    private Set<StartElementToken> toSet(String[] names, Namespace ns) {
        HashSet<StartElementToken> elements = new HashSet<StartElementToken>(names.length);
        for (String name : names) {
            elements.add(new XMLStartElement(ns.getUri(), name));
        }
        return elements;
    }
}

