/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class LimitedSizeCache<K, V> {
    private final int maxSize;
    private final Map<K, V> cache;

    public LimitedSizeCache(int maxSize) {
        this.maxSize = maxSize;
        this.cache = new LinkedHashMap<K, V>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > LimitedSizeCache.this.maxSize;
            }
        };
    }

    public V getOrCreate(K key, Function<K, V> valueFactory) {
        if (this.cache.size() >= this.maxSize && !this.cache.containsKey(key)) {
            return valueFactory.apply(key);
        }
        return this.cache.computeIfAbsent(key, valueFactory);
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.clear();
    }
}

