/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.WordToken;
import org.pageseeder.diffx.token.impl.XMLStartElement;
import org.pageseeder.diffx.xml.Namespace;
import org.pageseeder.diffx.xml.SequenceProcessor;

public class ExtendedWhitespaceStripper
implements SequenceProcessor {
    private final Set<StartElementToken> alwaysIgnore = new HashSet<StartElementToken>();
    private final Set<StartElementToken> maybeIgnore = new HashSet<StartElementToken>();

    public void setAlwaysIgnore(String ... names) {
        this.setAlwaysIgnore(Namespace.NO_NAMESPACE, names);
    }

    public void setMaybeIgnore(String ... names) {
        this.setMaybeIgnore(Namespace.NO_NAMESPACE, names);
    }

    public void setAlwaysIgnore(Namespace ns, String ... names) {
        this.alwaysIgnore.clear();
        this.alwaysIgnore.addAll(this.toSet(names, ns));
    }

    public void setMaybeIgnore(Namespace ns, String ... names) {
        this.maybeIgnore.clear();
        this.maybeIgnore.addAll(this.toSet(names, ns));
    }

    StripWhitespace forElement(StartElementToken start) {
        if (this.alwaysIgnore.contains(start)) {
            return StripWhitespace.ALWAYS;
        }
        if (this.maybeIgnore.contains(start)) {
            return StripWhitespace.LEADING;
        }
        return StripWhitespace.NEVER;
    }

    @Override
    @NotNull
    public List<XMLToken> process(@NotNull List<XMLToken> tokens) {
        ArrayDeque<StripWhitespace> context = new ArrayDeque<StripWhitespace>();
        ArrayList<XMLToken> out = new ArrayList<XMLToken>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            XMLToken token = tokens.get(i);
            XMLTokenType type = token.getType();
            boolean include = true;
            if (type == XMLTokenType.START_ELEMENT) {
                StripWhitespace sc = this.forElement((StartElementToken)token);
                context.push(sc);
            } else if (type == XMLTokenType.END_ELEMENT) {
                context.pop();
            } else if (type == XMLTokenType.TEXT) {
                if (token.isWhitespace()) {
                    include = this.includeWhitespace(context, tokens, i);
                } else if (context.peek() == StripWhitespace.LEADING) {
                    if (token.getValue().startsWith(" ")) {
                        out.add(new WordToken(token.getValue().substring(1)));
                        include = false;
                    }
                    this.replaceByTrailing(context);
                } else if (context.peek() == StripWhitespace.NEVER) {
                    this.replaceByTrailing(context);
                }
            }
            if (!include) continue;
            out.add(token);
        }
        return out;
    }

    private boolean includeWhitespace(Deque<StripWhitespace> context, List<XMLToken> tokens, int i) {
        XMLToken next;
        StripWhitespace stripContext = context.peek();
        if (stripContext == StripWhitespace.ALWAYS) {
            return false;
        }
        if (stripContext == StripWhitespace.LEADING) {
            XMLToken next2 = tokens.get(i + 1);
            if (next2.getType() == XMLTokenType.TEXT) {
                return false;
            }
            if (next2.getType() == XMLTokenType.START_ELEMENT) {
                this.replaceByTrailing(context);
                StripWhitespace sc = this.forElement((StartElementToken)next2);
                if (sc == StripWhitespace.NEVER) {
                    this.replaceByTrailing(context);
                }
                return false;
            }
            if (next2.getType() == XMLTokenType.END_ELEMENT) {
                return false;
            }
        } else if (stripContext == StripWhitespace.TRAILING && (next = tokens.get(i + 1)).getType() == XMLTokenType.END_ELEMENT) {
            return false;
        }
        return true;
    }

    private Set<StartElementToken> toSet(String[] names, Namespace ns) {
        HashSet<StartElementToken> elements = new HashSet<StartElementToken>(names.length);
        for (String name : names) {
            elements.add(new XMLStartElement(ns.getUri(), name));
        }
        return elements;
    }

    void replaceByTrailing(Deque<StripWhitespace> context) {
        Object[] items = context.toArray();
        context.clear();
        for (int i = items.length - 1; i >= 0; --i) {
            StripWhitespace item = (StripWhitespace)((Object)items[i]);
            context.push(item == StripWhitespace.LEADING ? StripWhitespace.TRAILING : item);
        }
    }

    static enum StripWhitespace {
        ALWAYS,
        LEADING,
        TRAILING,
        NEVER;

    }
}

