/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.xmlwriter.XMLWriter;

public final class TextListToken
implements TextToken {
    private final TextToken[] tokens;

    public TextListToken(List<? extends TextToken> tokens) {
        this.tokens = tokens.toArray(new TextToken[0]);
    }

    @Override
    public String getCharacters() {
        StringBuilder chars = new StringBuilder();
        for (TextToken token : this.tokens) {
            chars.append(token.getCharacters());
        }
        return chars.toString();
    }

    @Override
    public void toXML(XMLWriter xml) throws IOException {
        for (TextToken text : this.tokens) {
            text.toXML(xml);
        }
    }

    @Override
    public void toXML(@NotNull XMLStreamWriter xml) throws XMLStreamException {
        for (TextToken text : this.tokens) {
            text.toXML(xml);
        }
    }

    public String toString() {
        return Arrays.toString(this.tokens);
    }

    @Override
    public int hashCode() {
        return this.getCharacters().hashCode();
    }

    @Override
    public boolean equals(XMLToken token) {
        if (token == this) {
            return true;
        }
        if (!(token instanceof TextToken)) {
            return false;
        }
        if (this.hashCode() != token.hashCode()) {
            return false;
        }
        TextToken other = (TextToken)token;
        return this.getCharacters().equals(other.getCharacters());
    }
}

