/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.impl.TokenBase;
import org.pageseeder.xmlwriter.XMLWriter;

public final class LineToken
extends TokenBase
implements TextToken {
    private final CharSequence characters;
    private final int lineNumber;
    private final int hashCode;

    public LineToken(CharSequence line, int lineNumber) throws NullPointerException {
        if (line == null) {
            throw new NullPointerException("The line cannot be null, use \"\"");
        }
        this.characters = line;
        this.lineNumber = lineNumber;
        this.hashCode = this.toHashCode(line);
    }

    public String toString() {
        return "line:" + this.lineNumber + ": \"" + this.getCharacters() + "\"";
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(XMLToken token) {
        if (token == null) {
            return false;
        }
        if (this == token) {
            return true;
        }
        if (token.getClass() != LineToken.class) {
            return false;
        }
        LineToken ce = (LineToken)token;
        return ce.characters.equals(this.characters);
    }

    @Override
    public String getCharacters() {
        return this.characters.toString();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void toXML(XMLWriter xml) throws IOException {
        xml.writeXML(this.characters.toString());
    }

    @Override
    public void toXML(@NotNull XMLStreamWriter xml) throws XMLStreamException {
        xml.writeCharacters(this.characters.toString());
    }

    private int toHashCode(CharSequence line) {
        assert (line != null);
        return 1711 + line.hashCode();
    }
}

