/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.token.impl;

import java.io.IOException;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.token.TextToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.impl.TokenBase;
import org.pageseeder.xmlwriter.XMLWriter;

public abstract class CharactersTokenBase
extends TokenBase
implements TextToken {
    private final String characters;
    private final int hashCode;

    protected CharactersTokenBase(CharSequence seq) throws NullPointerException {
        this.characters = Objects.requireNonNull(seq.toString(), "The characters cannot be null, use \"\"");
        this.hashCode = CharactersTokenBase.toHashCode(seq);
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public final boolean equals(XMLToken token) {
        if (this == token) {
            return true;
        }
        if (!(token instanceof TextToken)) {
            return false;
        }
        TextToken ce = (TextToken)token;
        return ce.getCharacters().equals(this.getCharacters());
    }

    @Override
    public final String getCharacters() {
        return this.characters;
    }

    @Override
    public final void toXML(XMLWriter xml) throws IOException {
        xml.writeText(this.characters);
    }

    @Override
    public void toXML(@NotNull XMLStreamWriter xml) throws XMLStreamException {
        xml.writeCharacters(this.characters);
    }

    private static int toHashCode(CharSequence s) {
        assert (s != null);
        return 611 + s.hashCode();
    }
}

