/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.similarity;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.api.DiffAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.similarity.Similarity;
import org.pageseeder.diffx.token.Token;

public final class SimilarityWagnerFischerAlgorithm<T extends Token>
implements DiffAlgorithm<T> {
    private static final byte MATCH = 0;
    private static final byte DELETE = 1;
    private static final byte INSERT = 2;
    private final Similarity<T> similarity;
    private final float minThreshold;

    public SimilarityWagnerFischerAlgorithm(Similarity<T> similarity, float minThreshold) {
        this.similarity = similarity;
        this.minThreshold = minThreshold;
    }

    @Override
    public void diff(@NotNull List<? extends T> from, @NotNull List<? extends T> to, @NotNull DiffHandler<T> handler) {
        if (from.isEmpty()) {
            for (Token t : to) {
                handler.handle(Operator.INS, t);
            }
            return;
        }
        if (to.isEmpty()) {
            for (Token t : from) {
                handler.handle(Operator.DEL, t);
            }
            return;
        }
        if (from.size() == 1 && to.size() == 1) {
            Token toToken;
            Token fromToken = (Token)from.get(0);
            float score = this.similarity.score(fromToken, toToken = (Token)to.get(0));
            if (score >= this.minThreshold) {
                handler.handle(Operator.MATCH, fromToken);
            } else {
                handler.handle(Operator.DEL, fromToken);
                handler.handle(Operator.INS, toToken);
            }
            return;
        }
        Instance<Token> instance = new Instance<Token>(from, to);
        instance.process(handler, this.similarity, this.minThreshold);
    }

    private static class Instance<T> {
        private final List<? extends T> from;
        private final List<? extends T> to;

        Instance(List<? extends T> from, List<? extends T> to) {
            this.from = from;
            this.to = to;
        }

        public void process(DiffHandler<T> handler, Similarity<T> similarity, float minThreshold) {
            byte[][] decisions = this.computeDecisions(similarity, minThreshold);
            this.handle(decisions, handler);
        }

        private byte[][] computeDecisions(Similarity<T> similarity, float minThreshold) {
            int i;
            int fromSize = this.from.size();
            int toSize = this.to.size();
            float[] prevRow = new float[toSize + 1];
            float[] currRow = new float[toSize + 1];
            byte[][] decisions = new byte[fromSize + 1][toSize + 1];
            for (int j = 0; j <= toSize; ++j) {
                decisions[fromSize][j] = 2;
            }
            for (i = 0; i <= fromSize; ++i) {
                decisions[i][toSize] = 1;
            }
            for (i = fromSize - 1; i >= 0; --i) {
                for (int j = toSize - 1; j >= 0; --j) {
                    float score = similarity.score(this.from.get(i), this.to.get(j));
                    float matchScore = prevRow[j + 1] + (score >= minThreshold ? score : 0.0f);
                    float deleteScore = prevRow[j];
                    float insertScore = currRow[j + 1];
                    if (matchScore >= deleteScore && matchScore >= insertScore && score >= minThreshold) {
                        currRow[j] = matchScore;
                        decisions[i][j] = 0;
                        continue;
                    }
                    if (deleteScore >= insertScore) {
                        currRow[j] = deleteScore;
                        decisions[i][j] = 1;
                        continue;
                    }
                    currRow[j] = insertScore;
                    decisions[i][j] = 2;
                }
                float[] temp = prevRow;
                prevRow = currRow;
                currRow = temp;
            }
            return decisions;
        }

        private void handle(byte[][] decisions, DiffHandler<T> handler) {
            int i = 0;
            int j = 0;
            while (i < this.from.size() && j < this.to.size()) {
                byte decision = decisions[i][j];
                if (decision == 0) {
                    handler.handle(Operator.MATCH, this.from.get(i));
                    ++i;
                    ++j;
                    continue;
                }
                if (decision == 1) {
                    handler.handle(Operator.DEL, this.from.get(i));
                    ++i;
                    continue;
                }
                handler.handle(Operator.INS, this.to.get(j));
                ++j;
            }
            while (i < this.from.size()) {
                handler.handle(Operator.DEL, this.from.get(i));
                ++i;
            }
            while (j < this.to.size()) {
                handler.handle(Operator.INS, this.to.get(j));
                ++j;
            }
        }
    }
}

