/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.similarity;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.algorithm.MyersGreedyAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.similarity.StreamSimilarity;

public final class EditSimilarity<T>
implements StreamSimilarity<T> {
    @Override
    public float score(@NotNull Stream<T> a, @NotNull Stream<T> b) {
        MyersGreedyAlgorithm alg = new MyersGreedyAlgorithm();
        EditCounter counter = new EditCounter();
        alg.diff(a.collect(Collectors.toList()), b.collect(Collectors.toList()), counter);
        return counter.score();
    }

    private static class EditCounter<T>
    implements DiffHandler<T> {
        int edits = 0;
        int tokens = 0;

        private EditCounter() {
        }

        @Override
        public void handle(Operator operator, T token) {
            if (operator == Operator.MATCH) {
                this.tokens += 2;
            } else {
                ++this.edits;
                ++this.tokens;
            }
        }

        float score() {
            if (this.tokens == 0) {
                return 0.5f;
            }
            if (this.edits == 0) {
                return 1.0f;
            }
            return 1.0f - (float)this.edits / (float)this.tokens;
        }
    }
}

