/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.similarity;

import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.similarity.StreamSimilarity;

public final class CosineSimilarity<T>
implements StreamSimilarity<T> {
    @Override
    public float score(@NotNull Stream<T> a, @NotNull Stream<T> b) {
        Map<T, Integer> freqA = this.toFreqMap(a);
        Map<T, Integer> freqB = this.toFreqMap(b);
        double dotProduct = 0.0;
        double magA = 0.0;
        double magB = 0.0;
        for (Map.Entry<T, Integer> entry : freqA.entrySet()) {
            T token = entry.getKey();
            int countA = entry.getValue();
            int countB = freqB.getOrDefault(token, 0);
            dotProduct += (double)(countA * countB);
            magA += (double)(countA * countA);
        }
        Iterator<Object> iterator = freqB.values().iterator();
        while (iterator.hasNext()) {
            int countB = (Integer)iterator.next();
            magB += (double)(countB * countB);
        }
        if (magA == 0.0 || magB == 0.0) {
            return 1.0f;
        }
        return (float)(dotProduct / (Math.sqrt(magA) * Math.sqrt(magB)));
    }

    private Map<T, Integer> toFreqMap(Stream<T> children) {
        return children.collect(Collectors.toMap(item -> item, item -> 1, Integer::sum));
    }
}

