/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.load;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.pageseeder.diffx.api.Loader;
import org.pageseeder.diffx.token.impl.LineToken;

public final class LineLoader
implements Loader<LineToken> {
    @Override
    public List<LineToken> load(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            List<LineToken> list = this.getLines(reader);
            return list;
        }
    }

    @Override
    public List<LineToken> load(File file, Charset charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), charset));){
            List<LineToken> list = this.getLines(reader);
            return list;
        }
    }

    @Override
    public List<LineToken> load(Reader reader) throws IOException {
        try (BufferedReader buffer = new BufferedReader(reader);){
            List<LineToken> list = this.getLines(buffer);
            return list;
        }
    }

    @Override
    public List<LineToken> load(String text) {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(text));
            return this.getLines(reader);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private List<LineToken> getLines(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        int count = 0;
        ArrayList<LineToken> sequence = new ArrayList<LineToken>();
        while (line != null) {
            sequence.add(new LineToken(line, ++count));
            line = reader.readLine();
        }
        return sequence;
    }
}

