/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.handler;

import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Queue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.handler.DiffFilter;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.NilToken;
import org.pageseeder.diffx.token.impl.XMLEndElement;

@ApiStatus.Experimental
public class XMLEventBalancer
extends DiffFilter<XMLToken> {
    private final Deque<Operation<StartElementToken>> unclosed = new ArrayDeque<Operation<StartElementToken>>();
    private final Queue<XMLToken> deletions = new ArrayDeque<XMLToken>();
    private final Queue<XMLToken> insertions = new ArrayDeque<XMLToken>();
    private Operator lastOperator = Operator.MATCH;
    private XMLToken lastToken = NilToken.getInstance();
    private boolean hasError = false;

    public XMLEventBalancer(@NotNull DiffHandler<XMLToken> handler) {
        super(handler);
    }

    @Override
    public void handle(@NotNull Operator operator, @NotNull XMLToken token) throws UncheckedIOException, IllegalStateException {
        if (operator == Operator.DEL) {
            this.deletions.add(token);
        } else if (operator == Operator.INS) {
            this.insertions.add(token);
        } else {
            this.flushChanges();
            if (token.getType() == XMLTokenType.END_ELEMENT && !this.matchStart(Operator.MATCH, (EndElementToken)token)) {
                this.sendMatchingEndElement();
            } else {
                this.send(operator, token);
            }
        }
    }

    private void flushChanges() {
        while (!this.insertions.isEmpty() || !this.deletions.isEmpty()) {
            this.flushAttributes();
            XMLToken nextInsertion = this.insertions.peek();
            XMLToken nextDeletion = this.deletions.peek();
            Operation<StartElementToken> context = this.unclosed.peek();
            if (XMLEventBalancer.isEndElement(nextDeletion)) {
                if (this.matchStart(Operator.DEL, (EndElementToken)nextDeletion)) {
                    this.send(Operator.DEL, this.deletions.remove());
                    continue;
                }
                if (context != null && context.operator() == Operator.INS && !this.insertions.isEmpty()) {
                    this.send(Operator.INS, this.insertions.remove());
                    continue;
                }
                this.hasError = !this.followedByMatchingStart(this.deletions, (EndElementToken)nextDeletion);
                this.sendMatchingEndElement();
                this.deletions.remove();
                continue;
            }
            if (XMLEventBalancer.isEndElement(nextInsertion)) {
                if (this.matchStart(Operator.INS, (EndElementToken)nextInsertion)) {
                    this.send(Operator.INS, this.insertions.remove());
                    continue;
                }
                if (context != null && context.operator() == Operator.DEL && !this.deletions.isEmpty()) {
                    this.send(Operator.DEL, this.deletions.remove());
                    continue;
                }
                this.hasError = !this.followedByMatchingStart(this.insertions, (EndElementToken)nextInsertion);
                this.sendMatchingEndElement();
                this.insertions.remove();
                continue;
            }
            if (this.lastOperator == Operator.DEL && nextDeletion != null) {
                this.send(Operator.DEL, this.deletions.remove());
                continue;
            }
            if (this.lastOperator == Operator.INS && nextInsertion != null) {
                this.send(Operator.INS, this.insertions.remove());
                continue;
            }
            if (nextDeletion != null) {
                this.send(Operator.DEL, this.deletions.remove());
                continue;
            }
            if (nextInsertion == null) continue;
            this.send(Operator.INS, this.insertions.remove());
        }
    }

    private void flushAttributes() {
        XMLTokenType type = this.lastToken.getType();
        if (type == XMLTokenType.START_ELEMENT || type == XMLTokenType.ATTRIBUTE) {
            while (XMLEventBalancer.isAttribute(this.deletions.peek())) {
                this.send(Operator.DEL, this.deletions.remove());
            }
            while (XMLEventBalancer.isAttribute(this.insertions.peek())) {
                this.send(Operator.INS, this.insertions.remove());
            }
        }
    }

    public boolean hasError() {
        return this.hasError;
    }

    private boolean followedByMatchingStart(@NotNull Queue<XMLToken> queue, @NotNull EndElementToken endElement) {
        XMLToken following = XMLEventBalancer.followingPeek(queue);
        if (following == null) {
            return false;
        }
        return following.getType() == XMLTokenType.START_ELEMENT && endElement.getName().equals(following.getName()) && endElement.getNamespaceURI().equals(following.getNamespaceURI());
    }

    private static XMLToken followingPeek(@NotNull Queue<XMLToken> queue) {
        if (queue.size() >= 2) {
            return queue.stream().skip(1L).findFirst().orElse(null);
        }
        return null;
    }

    private static boolean isEndElement(XMLToken token) {
        return token != null && token.getType() == XMLTokenType.END_ELEMENT;
    }

    private static boolean isAttribute(XMLToken token) {
        return token != null && token.getType() == XMLTokenType.ATTRIBUTE;
    }

    private boolean matchStart(@NotNull Operator operator, @NotNull EndElementToken token) {
        Operation<StartElementToken> op = this.unclosed.peek();
        if (op == null) {
            return false;
        }
        return op.operator() == operator && token.match(op.token());
    }

    private void sendMatchingEndElement() {
        Operation<StartElementToken> lastStart = this.unclosed.peek();
        if (lastStart != null) {
            EndElementToken end = this.toEndElementToken(lastStart.token());
            this.send(lastStart.operator(), end);
        }
    }

    private EndElementToken toEndElementToken(@NotNull StartElementToken token) {
        return new XMLEndElement(token);
    }

    private void send(@NotNull Operator operator, @NotNull XMLToken token) {
        this.target.handle(operator, token);
        this.lastOperator = operator;
        this.lastToken = token;
        if (token.getType() == XMLTokenType.START_ELEMENT) {
            this.unclosed.push(new Operation<StartElementToken>(operator, (StartElementToken)token));
        } else if (token.getType() == XMLTokenType.END_ELEMENT) {
            this.unclosed.pop();
        }
    }

    @Override
    public void end() {
        this.flushChanges();
        while (!this.unclosed.isEmpty()) {
            this.sendMatchingEndElement();
        }
    }
}

