/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.handler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.handler.DiffFilter;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;

public final class XMLBalanceCheckFilter
extends DiffFilter<XMLToken> {
    private final Deque<Operation<XMLToken>> stack = new ArrayDeque<Operation<XMLToken>>();
    private List<String> errors = new ArrayList<String>(1);

    public XMLBalanceCheckFilter(DiffHandler<XMLToken> handler) {
        super(handler);
    }

    @Override
    public void start() {
        this.errors = new ArrayList<String>(0);
        this.stack.clear();
    }

    @Override
    public void handle(@NotNull Operator operator, @NotNull XMLToken token) {
        if (token.getType() == XMLTokenType.START_ELEMENT) {
            this.stack.push(new Operation<XMLToken>(operator, token));
        } else if (token.getType() == XMLTokenType.END_ELEMENT) {
            Operation<XMLToken> start = this.stack.peek();
            if (start == null) {
                this.errors.add("Unexpected " + String.valueOf((Object)operator) + String.valueOf(token));
            } else {
                this.stack.pop();
                if (start.operator() != operator || !start.token().getName().equals(token.getName()) || !start.token().getNamespaceURI().equals(token.getNamespaceURI())) {
                    this.errors.add("Expected " + String.valueOf((Object)start.operator()) + String.valueOf(start.token()) + ", but got " + String.valueOf((Object)operator) + String.valueOf(token));
                }
            }
        }
        this.target.handle(operator, token);
    }

    public boolean isBalanced() {
        return this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

