/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.format;

import java.util.EnumMap;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.format.XMLDiffOutput;
import org.pageseeder.diffx.xml.Namespace;
import org.pageseeder.diffx.xml.NamespaceSet;

abstract class XMLDiffOutputBase
implements XMLDiffOutput {
    private static final String DIFF_NS_URI = "https://www.pageseeder.org/diffx";
    private static final String LEGACY_DIFF_NS_URI = "http://www.topologi.com/2005/Diff-X";
    private static final EnumMap<Operator, Namespace> DEFAULT = new EnumMap(Operator.class);
    private static final EnumMap<Operator, Namespace> LEGACY;
    protected NamespaceSet namespaces = NamespaceSet.noNamespace();
    protected boolean includeXMLDeclaration = false;
    protected boolean useLegacyNamespaces = false;

    XMLDiffOutputBase() {
    }

    @Override
    public final void setWriteXMLDeclaration(boolean show) {
        this.includeXMLDeclaration = show;
    }

    @Override
    public final void setNamespaces(NamespaceSet namespaces) {
        this.namespaces = namespaces;
    }

    public Namespace getDiffNamespace() {
        return this.useLegacyNamespaces ? LEGACY.get((Object)Operator.MATCH) : DEFAULT.get((Object)Operator.MATCH);
    }

    public Namespace getDiffNamespace(Operator operator) {
        return this.useLegacyNamespaces ? LEGACY.get((Object)operator) : DEFAULT.get((Object)operator);
    }

    static {
        DEFAULT.put(Operator.MATCH, new Namespace(DIFF_NS_URI, "diff"));
        DEFAULT.put(Operator.INS, new Namespace("https://www.pageseeder.org/diffx/insert", "ins"));
        DEFAULT.put(Operator.DEL, new Namespace("https://www.pageseeder.org/diffx/delete", "del"));
        LEGACY = new EnumMap(Operator.class);
        LEGACY.put(Operator.MATCH, new Namespace(LEGACY_DIFF_NS_URI, "dfx"));
        LEGACY.put(Operator.INS, new Namespace("http://www.topologi.com/2005/Diff-X/Insert", "ins"));
        LEGACY.put(Operator.DEL, new Namespace("http://www.topologi.com/2005/Diff-X/Delete", "del"));
    }
}

