/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.core;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.action.OperationsBuffer;
import org.pageseeder.diffx.algorithm.DataLengthException;
import org.pageseeder.diffx.algorithm.MatrixXMLAlgorithm;
import org.pageseeder.diffx.algorithm.MyersGreedyAlgorithm;
import org.pageseeder.diffx.algorithm.MyersGreedyXMLAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.core.DiffProcessorBase;
import org.pageseeder.diffx.core.XMLDiffProcessor;
import org.pageseeder.diffx.handler.CoalescingFilter;
import org.pageseeder.diffx.handler.PostXMLFixer;
import org.pageseeder.diffx.token.XMLToken;

public final class OptimisticXMLProcessor
extends DiffProcessorBase
implements XMLDiffProcessor {
    private int fallbackThreshold = 64000000;
    private boolean isDownscaleAllowed = true;

    public void setDownscaleAllowed(boolean allowed) {
        this.isDownscaleAllowed = allowed;
    }

    boolean isDownscaleAllowed() {
        return this.isDownscaleAllowed;
    }

    public void setFallbackThreshold(int fallbackThreshold) {
        this.fallbackThreshold = fallbackThreshold;
    }

    @Override
    public void diff(@NotNull List<? extends XMLToken> from, @NotNull List<? extends XMLToken> to, @NotNull DiffHandler<XMLToken> handler) {
        OperationsBuffer<XMLToken> buffer = new OperationsBuffer<XMLToken>();
        boolean successful = this.fastDiff(from, to, buffer);
        if (successful) {
            buffer.applyTo(this.getFilter(handler));
        } else {
            try {
                this.fallbackDiffMyers(from, to, this.getFilter(handler));
            }
            catch (IllegalStateException ex) {
                this.fallbackDiffMatrix(from, to, this.getFilter(handler), false);
            }
        }
    }

    private DiffHandler<XMLToken> getFilter(DiffHandler<XMLToken> handler) {
        return this.coalesce ? new CoalescingFilter(handler) : handler;
    }

    private boolean fastDiff(List<? extends XMLToken> from, List<? extends XMLToken> to, OperationsBuffer<XMLToken> buffer) {
        MyersGreedyAlgorithm<XMLToken> algorithm = new MyersGreedyAlgorithm<XMLToken>();
        PostXMLFixer fixer = new PostXMLFixer((DiffHandler<XMLToken>)buffer);
        fixer.start();
        algorithm.diff(from, to, fixer);
        fixer.end();
        return !fixer.hasError();
    }

    private void fallbackDiffMatrix(List<? extends XMLToken> from, List<? extends XMLToken> to, DiffHandler<XMLToken> handler, boolean coalesced) {
        MatrixXMLAlgorithm algorithm = new MatrixXMLAlgorithm();
        DiffHandler<XMLToken> actual = this.getFilter(handler);
        if (algorithm.isDiffComputable(from, to)) {
            actual.start();
            algorithm.diff(from, to, actual);
            actual.end();
        } else if (!coalesced && this.isDownscaleAllowed) {
            List<? extends XMLToken> a = CoalescingFilter.coalesce(from);
            List<? extends XMLToken> b = CoalescingFilter.coalesce(to);
            this.fallbackDiffMatrix(a, b, handler, true);
        } else {
            throw new DataLengthException(from.size() * to.size(), this.fallbackThreshold);
        }
    }

    private void fallbackDiffMyers(List<? extends XMLToken> from, List<? extends XMLToken> to, DiffHandler<XMLToken> handler) {
        MyersGreedyXMLAlgorithm algorithm = new MyersGreedyXMLAlgorithm();
        DiffHandler<XMLToken> actual = this.getFilter(handler);
        actual.start();
        algorithm.diff(from, to, actual);
        actual.end();
    }

    public String toString() {
        return "OptimisticXMLProcessor{coalesce=" + this.coalesce + "}";
    }
}

