/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.core;

import java.util.List;
import org.pageseeder.diffx.DiffException;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.config.DiffConfig;
import org.pageseeder.diffx.core.XMLDiffProcessor;
import org.pageseeder.diffx.format.XMLDiffOutput;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.xml.NamespaceSet;
import org.pageseeder.diffx.xml.Sequence;

abstract class DiffProcessorBase
implements XMLDiffProcessor {
    protected boolean coalesce = false;

    DiffProcessorBase() {
    }

    @Override
    public void setCoalesce(boolean coalesce) {
        this.coalesce = coalesce;
    }

    @Override
    public boolean isCoalescing() {
        return this.coalesce;
    }

    @Override
    public void diff(Sequence from, Sequence to, DiffConfig config, DiffHandler<XMLToken> handler) throws DiffException {
        if (handler instanceof XMLDiffOutput) {
            NamespaceSet namespaces = NamespaceSet.merge(from.getNamespaces(), from.getNamespaces());
            ((XMLDiffOutput)handler).setNamespaces(namespaces);
        }
        this.diff((List<? extends XMLToken>)from.tokens(), (List<? extends XMLToken>)to.tokens(), handler);
    }
}

