/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.core;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.algorithm.MatrixXMLAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.core.DiffProcessor;
import org.pageseeder.diffx.core.DiffProcessorBase;
import org.pageseeder.diffx.handler.CoalescingFilter;
import org.pageseeder.diffx.token.XMLToken;

public class DefaultXMLProcessor
extends DiffProcessorBase
implements DiffProcessor<XMLToken> {
    private int threshold = 64000000;

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void setCoalesce(boolean coalesce) {
        this.coalesce = coalesce;
    }

    public boolean isDiffComputable(List<XMLToken> from, List<XMLToken> to) {
        MatrixXMLAlgorithm algorithm = new MatrixXMLAlgorithm();
        algorithm.setThreshold(this.threshold);
        return algorithm.isDiffComputable(from, to);
    }

    @Override
    public void diff(@NotNull List<? extends XMLToken> from, @NotNull List<? extends XMLToken> to, @NotNull DiffHandler<XMLToken> handler) {
        MatrixXMLAlgorithm algorithm = new MatrixXMLAlgorithm();
        algorithm.setThreshold(this.threshold);
        DiffHandler<XMLToken> actual = this.getFilter(handler);
        handler.start();
        algorithm.diff(from, to, actual);
        handler.end();
    }

    private DiffHandler<XMLToken> getFilter(DiffHandler<XMLToken> handler) {
        return this.coalesce ? new CoalescingFilter(handler) : handler;
    }

    public String toString() {
        return "DefaultXMLProcessor{coalesce=" + this.coalesce + "}";
    }
}

