/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.config;

import org.pageseeder.diffx.config.TextGranularity;
import org.pageseeder.diffx.config.WhiteSpaceProcessing;

public final class DiffConfig {
    private final boolean isNamespaceAware;
    private final WhiteSpaceProcessing whitespace;
    private final TextGranularity granularity;
    private final boolean allowDoctypeDeclaration;

    public DiffConfig(WhiteSpaceProcessing whitespace, TextGranularity granularity) {
        this(true, whitespace, granularity, false);
    }

    public DiffConfig(boolean isNamespaceAware, WhiteSpaceProcessing whitespace, TextGranularity granularity) {
        this(isNamespaceAware, whitespace, granularity, false);
    }

    private DiffConfig(boolean isNamespaceAware, WhiteSpaceProcessing whitespace, TextGranularity granularity, boolean allowDoctypeDeclaration) {
        this.isNamespaceAware = isNamespaceAware;
        this.whitespace = whitespace;
        this.granularity = granularity;
        this.allowDoctypeDeclaration = allowDoctypeDeclaration;
    }

    public boolean isNamespaceAware() {
        return this.isNamespaceAware;
    }

    public boolean allowDoctypeDeclaration() {
        return this.allowDoctypeDeclaration;
    }

    public TextGranularity granularity() {
        return this.granularity;
    }

    public WhiteSpaceProcessing whitespace() {
        return this.whitespace;
    }

    public static DiffConfig getDefault() {
        return new DiffConfig(true, WhiteSpaceProcessing.COMPARE, TextGranularity.SPACE_WORD);
    }

    public static DiffConfig legacyDefault() {
        return new DiffConfig(true, WhiteSpaceProcessing.COMPARE, TextGranularity.WORD);
    }

    public DiffConfig granularity(TextGranularity granularity) {
        return new DiffConfig(this.isNamespaceAware, this.whitespace, granularity, this.allowDoctypeDeclaration);
    }

    public DiffConfig whitespace(WhiteSpaceProcessing whitespace) {
        return new DiffConfig(this.isNamespaceAware, whitespace, this.granularity, this.allowDoctypeDeclaration);
    }

    public DiffConfig noNamespaces() {
        return new DiffConfig(false, this.whitespace, this.granularity, this.allowDoctypeDeclaration);
    }

    public DiffConfig allowDoctypeDeclaration(boolean allow) {
        return new DiffConfig(this.isNamespaceAware, this.whitespace, this.granularity, allow);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiffConfig that = (DiffConfig)o;
        return this.isNamespaceAware == that.isNamespaceAware && this.allowDoctypeDeclaration == that.allowDoctypeDeclaration && this.whitespace == that.whitespace && this.granularity == that.granularity;
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.isNamespaceAware);
        result = 31 * result + this.whitespace.hashCode();
        result = 31 * result + this.granularity.hashCode();
        result = 31 * result + Boolean.hashCode(this.allowDoctypeDeclaration);
        return result;
    }
}

