/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.pageseeder.diffx.algorithm.EdgeSnake;
import org.pageseeder.diffx.algorithm.Point;
import org.pageseeder.diffx.api.DiffAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;

abstract class MyersAlgorithm<T>
implements DiffAlgorithm<T> {
    MyersAlgorithm() {
    }

    protected void handleResults(List<? extends T> a, List<? extends T> b, DiffHandler<T> handler, List<EdgeSnake> snakes) {
        for (EdgeSnake snake : snakes) {
            if (snake.isForward()) {
                this.handleForward(a, b, handler, snake);
                continue;
            }
            this.handleReverse(a, b, handler, snake);
        }
    }

    private void handleForward(List<? extends T> a, List<? extends T> b, DiffHandler<T> handler, @NotNull EdgeSnake snake) {
        Point start = snake.getStartPoint();
        Point mid = snake.getMidPoint();
        Point end = snake.getEndPoint();
        this.handleEdited(a, b, handler, snake, start, mid);
        if (snake.matching > 0) {
            for (int i = mid.x(); i < end.x(); ++i) {
                handler.handle(Operator.MATCH, a.get(i));
            }
        }
    }

    private void handleReverse(List<? extends T> a, List<? extends T> b, DiffHandler<T> handler, @NotNull EdgeSnake snake) {
        Point start = snake.getEndPoint();
        Point mid = snake.getMidPoint();
        Point end = snake.getStartPoint();
        if (snake.matching > 0) {
            for (int i = start.x(); i < mid.x(); ++i) {
                handler.handle(Operator.MATCH, a.get(i));
            }
        }
        this.handleEdited(a, b, handler, snake, mid, end);
    }

    private void handleEdited(List<? extends T> a, List<? extends T> b, DiffHandler<T> handler, @NotNull EdgeSnake snake, Point start, Point mid) {
        block3: {
            block2: {
                if (snake.deleted() <= 0) break block2;
                for (int i = start.x(); i < mid.x(); ++i) {
                    handler.handle(Operator.DEL, a.get(i));
                }
                break block3;
            }
            if (snake.inserted() <= 0) break block3;
            for (int j = start.y(); j < mid.y(); ++j) {
                handler.handle(Operator.INS, b.get(j));
            }
        }
    }
}

