/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.algorithm;

import org.pageseeder.diffx.algorithm.Matrix;

public abstract class MatrixIntBase
implements Matrix {
    protected int[][] matrix;

    @Override
    public void setup(int width, int height) {
        this.matrix = new int[width][height];
    }

    @Override
    public void set(int i, int j, int x) {
        this.matrix[i][j] = x;
    }

    @Override
    public int get(int i, int j) {
        return this.matrix[i][j];
    }

    @Override
    public void release() {
        this.matrix = null;
    }

    @Override
    public int lengthX() {
        return this.matrix.length;
    }

    @Override
    public int lengthY() {
        return this.matrix[0].length;
    }

    @Override
    public boolean isGreaterX(int i, int j) {
        return this.matrix[i + 1][j] > this.matrix[i][j + 1];
    }

    @Override
    public boolean isGreaterY(int i, int j) {
        return this.matrix[i + 1][j] < this.matrix[i][j + 1];
    }

    @Override
    public boolean isSameXY(int i, int j) {
        return this.matrix[i + 1][j] == this.matrix[i][j + 1];
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (int j = 0; j < this.matrix[0].length; ++j) {
            for (int[] element : this.matrix) {
                out.append(element[j]).append("\t");
            }
            out.append('\n');
        }
        return out.toString();
    }
}

