/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.util;

import com.pageseeder.common.util.TokenValues;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenResolver {
    private static final int MIN_LENGTH_TOKEN = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenResolver.class);

    private TokenResolver() {
    }

    public static @Nullable String resolve(TokenValues pool, @Nullable String value) {
        String[] val = TokenResolver.resolveValues(pool, value);
        return val == null || val.length == 0 ? null : val[0];
    }

    public static String @Nullable [] resolveValues(@Nullable TokenValues pool, @Nullable String value) {
        String[] stringArray;
        boolean isWholyDynamic;
        String prop;
        if (value == null) {
            return null;
        }
        if (value.startsWith("{$") && value.endsWith("}") && pool != null) {
            return pool.getParameterValues(value.substring(2, value.length() - 1));
        }
        if (value.startsWith("{@") && value.endsWith("}") && pool != null && (prop = pool.getProperty(value.substring(2, value.length() - 1))) != null) {
            return new String[]{prop};
        }
        if (value.startsWith("{#") && value.endsWith("}") && pool != null) {
            String[] stringArray2;
            String o = pool.getVariable(value.substring(2, value.length() - 1));
            if (o == null) {
                stringArray2 = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = o.toString();
            }
            return stringArray2;
        }
        Pattern p = Pattern.compile("\\{([@$#])[\\w.\\-]+}");
        Matcher m = p.matcher(value);
        StringBuilder sb = new StringBuilder();
        int dynamic = 0;
        boolean foundOne = false;
        while (m.find()) {
            dynamic += m.end() - m.start();
            String replacement = TokenResolver.toValue(pool, value.substring(m.start(), m.end()));
            if (replacement != null) {
                foundOne = true;
                replacement = Matcher.quoteReplacement(replacement);
            }
            m.appendReplacement(sb, replacement != null ? replacement : "");
        }
        m.appendTail(sb);
        boolean bl = isWholyDynamic = dynamic > 0 && dynamic == value.length();
        if (isWholyDynamic && sb.length() == 0 && !foundOne) {
            stringArray = null;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = sb.toString();
        }
        return stringArray;
    }

    public static List<String> tokenise(@Nullable String value, boolean isParam) {
        if (value == null) {
            return Collections.emptyList();
        }
        String key = isParam ? "\\$" : "@";
        Pattern p = Pattern.compile("\\{" + key + "[\\w.\\-]+}");
        Matcher m = p.matcher(value);
        ArrayList<String> params = new ArrayList<String>();
        while (m.find()) {
            params.add(value.substring(m.start() + 2, m.end() - 1));
        }
        return params;
    }

    private static @Nullable String toValue(@Nullable TokenValues values, @Nullable String token) {
        if (token == null || values == null) {
            return "";
        }
        if (TokenResolver.isDynamicToken(token)) {
            if (token.charAt(1) == '$') {
                return values.getParameter(token.substring(2, token.length() - 1));
            }
            if (token.charAt(1) == '@') {
                return values.getProperty(token.substring(2, token.length() - 1));
            }
            if (token.charAt(1) == '#') {
                return values.getVariable(token.substring(2, token.length() - 1));
            }
            LOGGER.warn("Unknown token type '{}' for parameter.", (Object)token);
            return null;
        }
        return token;
    }

    public static boolean isDynamicToken(@Nullable String token) {
        return token != null && token.length() >= 4 && token.charAt(0) == '{' && token.charAt(token.length() - 1) == '}';
    }
}

