/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class InMemoryLRUCache<K, V> {
    private final int maxCacheSize;
    private final LinkedHashMap<K, V> map;

    public InMemoryLRUCache(int cacheSize) {
        this.maxCacheSize = cacheSize;
        this.map = new LinkedHashMap<K, V>(this.maxCacheSize, 0.75f, false){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > InMemoryLRUCache.this.maxCacheSize;
            }
        };
    }

    public synchronized void put(K key, V value) {
        this.map.put(key, value);
    }

    public synchronized @Nullable V get(K key) {
        return this.map.get(key);
    }

    public synchronized void remove(K key) {
        this.map.remove(key);
    }

    public synchronized int size() {
        return this.map.size();
    }
}

