/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.common.util;

public class Hex {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    private Hex() {
    }

    public static byte[] decode(String s) {
        Hex.checkInput(s);
        int length = s.length();
        byte[] out = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            out[i / 2] = Hex.decodeHexPair(s.charAt(i), s.charAt(i + 1));
        }
        return out;
    }

    private static void checkInput(String s) {
        if (s.length() % 2 != 0) {
            throw new IllegalArgumentException("hex string needs to be even-length: " + s);
        }
        for (char c : s.toCharArray()) {
            if (Hex.hexToBin(c) != -1) continue;
            throw new IllegalArgumentException("contains illegal character for hex string: " + s);
        }
    }

    private static byte decodeHexPair(char high, char low) {
        int h = Hex.hexToBin(high);
        int l = Hex.hexToBin(low);
        return (byte)(h * 16 + l);
    }

    private static int hexToBin(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    public static String encode(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_CHARS[v >>> 4];
            hexChars[i * 2 + 1] = HEX_CHARS[v & 0xF];
        }
        return new String(hexChars);
    }
}

